#!/usr/bin/perl
#=======================================================================
# FileName : AileNginxMonitoring.pl
# Summary  : Nginx監視コマンド
# ----------------------------------------------------------------------
# DATE       NAME               REASON
# ---------- ------------------ ----------------------------------------
# 2023/10/20 Kiyoshi Oishi      Initial Release
#=======================================================================
use strict;
use Encode;
use Data::Dumper;
use LWP::UserAgent;
use HTTP::Request;
use MIME::Base64;

use lib '/opt/aile-exctrl/com-lib';
use ComConst;
use ComLog;

use constant HTTP_STATUS_499 => 499;
use constant HTTP_STATUS_504 => 504;

my $rc = ComConst::STS_OK;

$rc = &main(\@ARGV);

exit $rc;

#=======================================================================
# FuncName : main
# Summary  : Nginx監視コマンドmain
# Argument : (IN)  $ARGV  : コマンド引数(ref)
# Return   : 正常:0, 異常:-1
# ----------------------------------------------------------------------
# DATE       NAME               REASON
# ---------- ------------------ ----------------------------------------
# 2023/10/20 Kiyoshi Oishi      Initial Release
#=======================================================================
sub main {
    my $rc = ComConst::STS_OK;
    my @argv = @{$_[0]};
    my $ua = LWP::UserAgent->new;
    my $req;

    my $aile_addr = $argv[0];
    my $aile_webuser = $argv[1];
    my $aile_webpass = decode_base64($argv[2]);

    $req = HTTP::Request->new(POST => 'http://'. $aile_webuser . ':' . $aile_webpass . '@' . $aile_addr . '/cgi-bin/aileun_home/getAileProductInfo.pl');

    my $res = $ua->request($req);
    if (HTTP_STATUS_499 == $res->code || HTTP_STATUS_504 == $res->code) {
        $rc = ComConst::STS_NG;
    }

    return $rc;
}
