#! /bin/sh

TIMESTAMP=`date +"%Y%m%d%H%M%S"`
BASE_PATH=`pwd`
DATA_DIR=$BASE_PATH/$1
TMP_DIR=/tmp
WORK_DIR=$TMP_DIR/$TIMESTAMP/$TIMESTAMP
ZIP_FILE_NAME=aile_log_$TIMESTAMP.zip
COMPRESS_FILE=$TMP_DIR/$ZIP_FILE_NAME

rm -f $DATA_DIR/aile_log_*.zip

# create working directory
mkdir -p $WORK_DIR/config
mkdir -p $WORK_DIR/log
mkdir -p $WORK_DIR/core

sudo cp /opt/aile/config/* $WORK_DIR/config/
sudo cp /var/log/syslog* $WORK_DIR/log/
sudo cp /var/log/Xorg* $WORK_DIR/log/
sudo cp /opt/aile/version.txt $WORK_DIR/log/
sudo cp /tmp/prdx2wr $WORK_DIR/log/

if [ -e /var/log/nginx ]; then
	sudo cp -r /var/log/nginx $WORK_DIR/log/
fi

CORES=`ls /opt/aile/aile.core.tgz 2>/dev/null | wc -l`
if [ $CORES -ne 0 ]; then
	COMPRESSING=`ps auxw | grep "packcore.sh" | grep -v grep | wc -l`
	if [ $COMPRESSING -eq 0 ]; then
		sudo cp /opt/aile/aile.core.tgz $WORK_DIR/core/
		if [ $? -ne 0 ]; then
			echo "[WARNING] can not copy core files,"
			echo "so don't remove core files in internal storage."
			rm $WORK_DIR/core/aile.core.tgz
			touch $WORK_DIR/core/cannotcopy
		fi
	else
		touch $WORK_DIR/core/compressing
	fi
fi

cd $TMP_DIR/$TIMESTAMP
sudo zip -A -r $COMPRESS_FILE ./* > /dev/null
sudo rm -fr $TMP_DIR/$TIMESTAMP
sudo chown www-data:www-data $COMPRESS_FILE
sudo mv $COMPRESS_FILE $DATA_DIR/

echo "$ZIP_FILE_NAME"
