#! /bin/bash

# Aileunのモデル番号
# 最新のモデル番号
AILEUN_LAST_MODEL_NUMBER=8
# 一番古いモデル番号
AILEUN_OLDEST_MODEL_NUMBER=1

#TMP_DIR=/tmp
TMP_DIR=/opt/aile/uploaded
WORK_DIR=$TMP_DIR/work
AILEUN_CONF_DIR=aileun_8/config
STAT=0

if [ $# -ne 1 ]; then
	exit 1
fi
# アップロードファイル名
ZIP_FILE_NAME=$1

# 作業ディレクトリ作成
mkdir -p $WORK_DIR
# zipを解凍
unzip $TMP_DIR/$ZIP_FILE_NAME -d $WORK_DIR > /dev/null

# ファイル名を強制的に*.zipに変更するので、zip形式でないファイルもzipになるが、
# unzipでエラーが起こるものはzip形式のファイルではないため、エラー
status=`echo $?`
if [ $status -ne 0 ]; then
	STAT=2
fi

if [ $STAT -eq 0 ]; then
	STAT=3
	# 最新のモデルから下位モデルの設定ファイルを検索する
	for no in `seq $AILEUN_LAST_MODEL_NUMBER -1 $AILEUN_OLDEST_MODEL_NUMBER`
	do
		AILEUN_CONF_DIR=`printf "aileun_%d/config" $no`
		IS_EXIST_CONF_DIR=0
		if [ -e $WORK_DIR/$AILEUN_CONF_DIR ]; then
			IS_EXIST_CONF_DIR=1
		fi
		if [ $IS_EXIST_CONF_DIR = 1 ]; then
			# 必須の設定ファイルがあるかチェック
			if [ -e "$WORK_DIR/$AILEUN_CONF_DIR/AileConfig.conf" -a -e "$WORK_DIR/$AILEUN_CONF_DIR/NetworkConfig.conf" ]; then
				STAT=0
				break
			fi
	 	fi
	done
fi

if [ $STAT -ne 0 ]; then
	rm -f $TMP_DIR/$ZIP_FILE_NAME
fi
rm -fr $WORK_DIR

exit $STAT
