#! /bin/sh

TMP_DIR=/tmp
CHKTMP_DIR=$TMP_DIR/work
CHECKSUM_FILE=aileun8.txt
STAT=0

if [ $# -ne 1 ]; then
	exit 1
fi
AILE_PKG_NAME=$1
AILE_PKG=/tmp/$AILE_PKG_NAME

mkdir $CHKTMP_DIR
tar zxvfp $AILE_PKG -C $CHKTMP_DIR > /dev/null
status=`echo $?`
if [ $status -ne 0 ]; then
	STAT=5
fi

cd $CHKTMP_DIR
if [ -e $CHECKSUM_FILE ]; then
	md5sum -c $CHECKSUM_FILE > /dev/null
	if [ $? -ne 0 ]; then
		STAT=5
	fi
else
	STAT=5
fi

if [ $STAT -ne 0 ]; then
	rm -f $AILE_PKG
fi
rm -fr $CHKTMP_DIR

exit $STAT
