#!/usr/bin/perl
#=======================================================================
# FileName : AileHttpAlarm.pl
# Summary  : TOAアラーム通知API
# ----------------------------------------------------------------------
# DATE       NAME               REASON
# ---------- ------------------ ----------------------------------------
# 2018/06/01 Kiyoshi Oishi      Initial Release
#=======================================================================
use strict;
use CGI;
use JSON;
use Data::Dumper;
use Encode;
use Socket;

use lib '../com-lib';
use ComConst;
use ComFunc;
use ComLog;

my $rc = ComConst::STS_OK;

$rc = &main();

#=======================================================================
# FuncName : main
# Summary  : 再起動メイン処理
# Argument : (IN)  $reqFile  : リクエストファイル名(scalar)
#          : (IN)  $resFile  : レスポンスファイル名(scalar)
# Return   : 正常:0, 異常:-1
# ----------------------------------------------------------------------
# DATE       NAME               REASON
# ---------- ------------------ ----------------------------------------
# 2018/06/01 Kiyoshi Oishi      Initial Release
#=======================================================================
sub main {
    my $rc = ComConst::STS_OK;
    my %conf = ();
    my %messages = ();
    my $cgi = new CGI;
    my %request = ();
    my %res_data = (ComConst::JSON_KEY_STS=>ComConst::STS_OK, ComConst::JSON_KEY_MSG=>"");
    my $resData = "";
    my $header = "";
    my $cmdData  = "";

    # 初期化処理
    if ($rc == ComConst::STS_OK) {
        $rc = ComFunc::initializeApi($0, \%conf, \%messages);
    }

    # 開始ログ出力
    ComLog::log_output(ComLog::LOG_DEBUG, $messages{CM000D001});

    # リクエストデータの取得
    if ($rc == ComConst::STS_OK) {
        $rc = ComFunc::getCtrlAipRequestData(\$cgi, \%request);
        if ($rc != ComConst::STS_OK) {
            $res_data{ComConst::JSON_KEY_STS} = ComConst::STS_NG;
        }
    }
    
    # リクエストデータ
    ComLog::log_output(ComLog::LOG_DEBUG, Dumper(\%request));

    # リクエストパラメータチェック
    if ($rc == ComConst::STS_OK) {
        foreach my $key (keys(%$ComConst::HTTP_REQUEST_KEYS)) {
            if (!defined($request{$key})) {
                $rc = ComConst::STS_NG;
                last;
            }
            if (defined($$ComConst::HTTP_REQUEST_KEYS{$key}->{range})) {
                if ($request{$key} < $$ComConst::HTTP_REQUEST_KEYS{$key}->{range}->[0] || $request{$key} > $$ComConst::HTTP_REQUEST_KEYS{$key}->{range}->[1]) {
                    $rc = ComConst::STS_NG;
                    last;
                }
            }
            # Viewerは0〜15なので指定された番号-1しておく
            $request{$key} = $request{$key} - 1;
        }
        if ($rc != ComConst::STS_OK) {
            $res_data{ComConst::JSON_KEY_STS} = $rc;
            $res_data{ComConst::JSON_KEY_MSG} = $messages{CM004E001};
        }
    }

    # リクエストデータ作成
    if ($rc == ComConst::STS_OK) {
        # nothing
    }

    # リクエストデータをファイルに出力
    if ($rc == ComConst::STS_OK) {
        # nothing
    }

    # コマンドを呼び出し
    if ($rc == ComConst::STS_OK) {
        # Unix domainで通信する
        my $server_sock;
        socket($server_sock, AF_UNIX, SOCK_STREAM, 0);
        if (!$server_sock) {
            $rc = ComConst::STS_NG;
            $res_data{ComConst::JSON_KEY_STS} = $rc;
            $res_data{ComConst::JSON_KEY_MSG} = "Socketの作成に失敗しました";
        } else {
            # 接続
            my $ret_connect = connect($server_sock, pack_sockaddr_un(ComConst::HTTP_ALARM_SOCK_PATH));
            if ($ret_connect) {
                # 書き込み
                printf($server_sock "%c", $request{ViewCH});
            } else {
                $rc = ComConst::STS_NG;
                $res_data{ComConst::JSON_KEY_STS} = $rc;
                $res_data{ComConst::JSON_KEY_MSG} = "サーバーへの接続に失敗しました";
            }
            # 切断
            close($server_sock);
        }
    }

    # 結果ファイルを読込む
    $resData = ComFunc::readResponseFile($conf{JSON_FILE}->{RESPONSE}, \%res_data);
    ComLog::log_output(ComLog::LOG_DEBUG, Dumper($resData));

    # リクエストファイルとレスポンスファイルを削除
    ComFunc::rmJsonFile($conf{JSON_FILE});

    # 結果を返す
    $header = $cgi->header(-type=>'application/json', -charset=>'UTF-8');
    ComFunc::setResponsData($resData, $header);

    # 終了ログ出力
    ComLog::log_output(ComLog::LOG_DEBUG, $messages{CM000D002});

    return $rc;
}
