#!/usr/bin/perl
#=======================================================================
# FileName : AileMsgDel.pl
# Summary  : ポップアップメッセージ受信API
# ----------------------------------------------------------------------
# DATE       NAME               REASON
# ---------- ------------------ ----------------------------------------
# 2018/06/01 Kiyoshi Oishi      Initial Release
#=======================================================================
use strict;
use CGI;
use JSON;
use Encode;
use Data::Dumper;
use IO::Socket::INET;
use Socket;

use lib '../com-lib';
use ComConst;
use ComFunc;
use ComLog;

my $rc = ComConst::STS_OK;

$rc = &main();

#=======================================================================
# FuncName : main
# Summary  : メイン処理
# Argument : (IN)  $reqFile  : リクエストファイル名(scalar)
#          : (IN)  $resFile  : レスポンスファイル名(scalar)
# Return   : 正常:0, 異常:-1
# ----------------------------------------------------------------------
# DATE       NAME               REASON
# ---------- ------------------ ----------------------------------------
# 2018/06/01 Kiyoshi Oishi      Initial Release
#=======================================================================
sub main {
    my $rc = ComConst::STS_OK;
    my %conf = ();
    my %messages = ();
    my $cgi = new CGI;
    my %request = ();
    my %res_data  = (ComConst::JSON_KEY_STS=>ComConst::STS_OK, ComConst::JSON_KEY_MSG=>"", ComConst::JSON_KEY_DAT=>());
    my $resData   = "";
    my $header    = "";
    my $postData  = "";
    my $basicAuth = "";
    my $data_value      = "";
    my %procResponse = (
        status  => ComConst::STS_OK, 
        data    => (),
        message => ""
    );

    # 初期化処理
    if ($rc == ComConst::STS_OK) {
        $rc = ComFunc::initializeApi($0, \%conf, \%messages);
    }

    # 開始ログ出力
    ComLog::log_output(ComLog::LOG_DEBUG, $messages{CM000D001});

    # リクエストデータの取得
    if ($rc == ComConst::STS_OK) {
        $rc = ComFunc::getCtrlAipRequestData(\$cgi, \%request);
        if ($rc != ComConst::STS_OK) {
            $res_data{ComConst::JSON_KEY_STS} = ComConst::STS_NG;
        }
    }
    
    # リクエストデータ
    ComLog::log_output(ComLog::LOG_DEBUG, Dumper(\%request));

    # リクエストパラメータチェック
    if ($rc == ComConst::STS_OK) {
        # パラメータなし
    }

    # Basic認証データ取得
    if ($rc == ComConst::STS_OK) {
        my @httpAuth = split(/ /, $ENV{HTTP_AUTHORIZATION});
        $basicAuth = $httpAuth[1];
    }

    # リクエストデータ作成
    if ($rc == ComConst::STS_OK) {
        my $alarm_ctl_param = "";
        $postData = sprintf(ComConst::INQLALARMCTLDELDATATEMPLATE, $alarm_ctl_param, $basicAuth);
    }

    # リクエストデータをファイルに出力
    if ($rc == ComConst::STS_OK) {
        # nothing
    }

    # コマンドを呼び出し
    if ($rc == ComConst::STS_OK) {
        my $requestData = decode_json("[" . $postData . "]");
        aileunProcCom($requestData->[0], \%conf, \%procResponse);
        $res_data{ComConst::JSON_KEY_STS} = $procResponse{status};
        $res_data{ComConst::JSON_KEY_DAT} = $procResponse{data};
        if (-1 == $res_data{ComConst::JSON_KEY_STS}) {
            $res_data{ComConst::JSON_KEY_MSG} = $messages{$procResponse{message}};
        } else {
            $res_data{ComConst::JSON_KEY_MSG} = $procResponse{message};
        }
    }

    # 結果ファイルを読込む
    $resData = ComFunc::readResponseFile($conf{JSON_FILE}->{RESPONSE}, \%res_data);
    ComLog::log_output(ComLog::LOG_DEBUG, Dumper($resData));

    # リクエストファイルとレスポンスファイルを削除
    ComFunc::rmJsonFile($conf{JSON_FILE});

    # 結果を返す
    $header = $cgi->header(-type=>'application/json', -charset=>'UTF-8');
    ComFunc::setResponsData($resData, $header);

    # 終了ログ出力
    ComLog::log_output(ComLog::LOG_DEBUG, $messages{CM000D002});

    return $rc;
}

#=======================================================================
# FuncName : aileunProcCom
# Summary  : Aileunとの通信処理
# Argument : (IN)  $id                : リクエストID(scalar)
#          : (IN)  $ref_conf          : 設定情報(ref_associate)
#          : (OUT) $ref_proc_Response : 通信結果(ref_associate)
# Return   : Nothing
# ----------------------------------------------------------------------
# DATE       NAME               REASON
# ---------- ------------------ ----------------------------------------
# 2015/03/06 Kiyoshi Oishi      Initial Release
#=======================================================================
sub aileunProcCom {
    my $data         = $_[0];
    my $ref_conf     = $_[1];
    my $ref_procResponse = $_[2];
    my $sendMessage = "";

    # 送信メッセージ作成
    $sendMessage = sprintf(ComConst::AILEUN_SEND_MSG, $data->{btnId}, $data->{reqType}, $data->{targetView}, $data->{reqData}, $data->{auth});

    # Aileunとプロセス間通信
    tcpSocketComMain($sendMessage, $ref_conf->{TCP_PORT}, $ref_conf->{TIME_OUT}, $ref_procResponse);
}

#=======================================================================
# FuncName : tcpSocketComMain
# Summary  : TCPソケット通信処理
# Argument : (IN)  $sendMessage      : 送信メッセージ(scalar)
#          : (IN)  $tcpPort          : Tcpポート番号(scalar)
#          : (IN)  $timeOut          : タイムアウト時間(scalar)
#          : (OUT) $ref_procResponse : 通信結果(ref_associate)
# Return   : Nothing
# ----------------------------------------------------------------------
# DATE       NAME               REASON
# ---------- ------------------ ----------------------------------------
# 2015/03/06 Kiyoshi Oishi      Initial Release
#=======================================================================
sub tcpSocketComMain {
    my $sendMessage      = $_[0];
    my $tcpPort          = $_[1];
    my $timeOut          = $_[2];
    my $ref_procResponse = $_[3];
    my $server;
    my $recvMessage = "";
    my $rv;

    # ソケットの作成 & 接続
    $server = IO::Socket::INET->new(
        PeerAddr => "localhost",
        PeerPort => $tcpPort,
        Prot => "tcp",
        Timeout => $timeOut,
    );

    if (!$server) {
        $ref_procResponse->{status} = ComConst::STS_NG;
    }

    # Aileunにメッセージ送信
    if ($server) {
        if ($sendMessage eq "") {
            # 空文字だとサーバからの応答が返ってこないため
            # メッセージがからの場合は半角スペースを送信
            $sendMessage = " ";
        }
        $server->send($sendMessage);
    }

    # Aileunからの応答受信
    if ($server) {
        $server->recv($recvMessage, 4096);
        parseProcResponse($recvMessage, $ref_procResponse);
    }

    # 切断
    if ($server) {
        $server->close();
    }
}

#=======================================================================
# FuncName : setResponseData
# Summary  : レスポンスデータ設定
# Argument : (OUT) $ref_resdata  : リクエストファイル名(reference)
#          : (IN)  $res_code     : レスポンスコード(scalar)
#          : (IN)  $res_message  : メッセージ(scalar)
# Return   : Nothing
# ----------------------------------------------------------------------
# DATE       NAME               REASON
# ---------- ------------------ ----------------------------------------
# 2015/11/26 Kiyoshi Oishi      Initial Release
#=======================================================================
sub setResponseData {
    my $ref_resdata = $_[0];
    my $res_code = $_[1];
    my $res_message = $_[2];

    $ref_resdata->{ComConst::JSON_KEY_STS} = $res_code;
    $ref_resdata->{ComConst::JSON_KEY_MSG} = $res_message;
}

#=======================================================================
# FuncName : parseProcResponse
# Summary  : Aileunから受信したメッセージを解析
# Argument : (IN)  $recvMessage      : 受信メッセージ(scalar)
#          : (OUT) $ref_procResponse : 通信結果(ref_associate)
# Return   : 変換後のデータ
# ----------------------------------------------------------------------
# DATE       NAME               REASON
# ---------- ------------------ ----------------------------------------
# 2015/03/12 Kiyoshi Oishi      Initial Release
#=======================================================================
sub parseProcResponse {
    my $recvMessage      = $_[0];
    my $ref_procResponse = $_[1];

    my $parseRes = decode_json($recvMessage);

    $ref_procResponse->{status}  = $parseRes->{status};
    $ref_procResponse->{data}    = $parseRes->{data};
    $ref_procResponse->{message} = $parseRes->{message};
}
