#!/usr/bin/perl
#=======================================================================
# FileName : getAileConfigFiles.pl
# Summary  : Aileun設定ファイル取得API
# ----------------------------------------------------------------------
# DATE       NAME               REASON
# ---------- ------------------ ----------------------------------------
# 2015/02/24 Kiyoshi Oishi      Initial Release
#=======================================================================
use strict;
use CGI;
use JSON;
use Encode;
use Data::Dumper;

use lib '../com-lib';
use ComConst;
use ComFunc;
use CmdComFunc;
use ComLog;

my $rc = ComConst::STS_OK;

$rc = &main();

exit $rc;

#=======================================================================
# FuncName : main
# Summary  : Aileun設定ファイル取得メイン処理
# Argument : (IN)  $reqFile  : リクエストファイル名(scalar)
#          : (IN)  $resFile  : レスポンスファイル名(scalar)
# Return   : 正常:0, 異常:-1
# ----------------------------------------------------------------------
# DATE       NAME               REASON
# ---------- ------------------ ----------------------------------------
# 2015/02/24 Kiyoshi Oishi      Initial Release
#=======================================================================
sub main {
    my $rc = ComConst::STS_OK;
    my %conf = ();
    my %messages = ();
    my $cgi = new CGI;
    my %request = ();
    my %res_data = (ComConst::JSON_KEY_STS=>ComConst::STS_OK, ComConst::JSON_KEY_MSG=>"", ComConst::JSON_KEY_DAT=>());
    my $resData = "";
    my $header = "";

    # 初期化処理
    if ($rc == ComConst::STS_OK) {
        $rc = ComFunc::initializeApi($0, \%conf, \%messages);
    }

    # 開始ログ出力
    ComLog::log_output(ComLog::LOG_DEBUG, $messages{CM000D001});

    # リクエストデータの取得
    if ($rc == ComConst::STS_OK) {
        $rc = ComFunc::getRequestData(\$cgi, \%request);
        if ($rc != ComConst::STS_OK) {
            $res_data{ComConst::JSON_KEY_STS} = ComConst::STS_NG;
        }
    }

    # リクエストデータをファイルに出力
    if ($rc == ComConst::STS_OK) {
        # nothing
    }

    # 機能制限チェック
    if ($rc == ComConst::STS_OK) {
        if (CmdComFunc::existWebFuncLimitFile() != ComConst::STS_OK) {
            $rc = ComConst::STS_NG;
            $res_data{ComConst::JSON_KEY_STS} = ComConst::STS_NG;
            $res_data{ComConst::JSON_KEY_MSG} = $messages{CM000E002} . "<br>" . $messages{CM000E003};
        }
    }

    # コマンドを呼び出し
    if ($rc == ComConst::STS_OK) {
        # Aileunの設定ファイルを取得
        my $exec_cmd = sprintf(ComConst::CMPRESS_AILEUN_CONFIG_CMD, ComConst::DATA_DIR_PATH);
        my $model = ComFunc::getAileunModelNumber();
        my $rv = `$exec_cmd`;
        
        if ($rv == ComConst::STS_OK) {
            my $zipfile = "";
            if ($model == ComConst::AILEUN_MODEL_5) {
                $zipfile = ComConst::AILEUN5_CONFIG_ZIPFILE;
            } elsif ($model == ComConst::AILEUN_MODEL_6) {
                $zipfile = ComConst::AILEUN6_CONFIG_ZIPFILE;
            } elsif ($model == ComConst::AILEUN_MODEL_7) {
                $zipfile = ComConst::AILEUN7_CONFIG_ZIPFILE;
            } elsif ($model == ComConst::AILEUN_MODEL_8) {
                $zipfile = ComConst::AILEUN8_CONFIG_ZIPFILE;
            } else {
                $zipfile = ComConst::AILEUN4_CONFIG_ZIPFILE;
            }
            $res_data{ComConst::JSON_KEY_DAT}{RedirectUrl} = sprintf("data/%s", $zipfile);
        } else {
            $res_data{ComConst::JSON_KEY_DAT}{RedirectUrl} = "";
            $res_data{ComConst::JSON_KEY_STS} = ComConst::STS_NG;
            $res_data{ComConst::JSON_KEY_MSG} = $messages{CM002E001};
        }
    }

    # 結果ファイルを読込む
    $resData = ComFunc::readResponseFile($conf{JSON_FILE}->{RESPONSE}, \%res_data);
    ComLog::log_output(ComLog::LOG_DEBUG, Dumper($resData));

    # リクエストファイルとレスポンスファイルを削除
    ComFunc::rmJsonFile($conf{JSON_FILE});

    # 結果を返す
    $header = $cgi->header(-type=>'application/json', -charset=>'UTF-8');
    ComFunc::setResponsData($resData, $header);

    # 終了ログ出力
    ComLog::log_output(ComLog::LOG_DEBUG, $messages{CM000D002});

    return $rc;
}
