#!/usr/bin/perl
#=======================================================================
# FileName : getWebFuncLimitedStatus.pl
# Summary  : 機能制限状態取得API
# ----------------------------------------------------------------------
# DATE       NAME               REASON
# ---------- ------------------ ----------------------------------------
# 2015/04/22 Kiyoshi Oishi      Initial Release
#=======================================================================
use strict;
use CGI;
use JSON;
use Encode;
use Data::Dumper;

use lib '../com-lib';
use ComConst;
use ComFunc;
use CmdComFunc;
use ComLog;

my $rc = ComConst::STS_OK;

$rc = &main();

exit $rc;

#=======================================================================
# FuncName : main
# Summary  : 機能制限状態取得メイン処理
# Argument : (IN)  $reqFile  : リクエストファイル名(scalar)
#          : (IN)  $resFile  : レスポンスファイル名(scalar)
# Return   : 正常:0, 異常:-1
# ----------------------------------------------------------------------
# DATE       NAME               REASON
# ---------- ------------------ ----------------------------------------
# 2015/04/22 Kiyoshi Oishi      Initial Release
#=======================================================================
sub main {
    my $rc = ComConst::STS_OK;
    my %conf = ();
    my %messages = ();
    my $cgi = new CGI;
    my %request = ();
    my %res_data = (ComConst::JSON_KEY_STS=>ComConst::STS_OK, ComConst::JSON_KEY_MSG=>"");
    my $resData = "";
    my $header = "";
    my $recvData;

    # 初期化処理
    if ($rc == ComConst::STS_OK) {
        $rc = ComFunc::initializeApi($0, \%conf, \%messages);
    }

    # 開始ログ出力
    ComLog::log_output(ComLog::LOG_DEBUG, $messages{CM000D001});

    # リクエストデータの取得
    if ($rc == ComConst::STS_OK) {
        # nothing
    }

    # リクエストデータをファイルに出力
    if ($rc == ComConst::STS_OK) {
        # nothing
    }

    # コマンドを呼び出し
    if ($rc == ComConst::STS_OK) {
        if (ComConst::STS_OK != CmdComFunc::existFile(ComConst::NOTIFY_FACTORY_DEFAULT)) {
            if (CmdComFunc::existWebFuncLimitFile() != ComConst::STS_OK) {
                $rc = ComConst::STS_NG;
                $res_data{ComConst::JSON_KEY_STS} = ComConst::STS_NG;
                $res_data{ComConst::JSON_KEY_MSG} = $messages{CM000E002} . "<br>" . $messages{CM000E003};
            }
        }
    }

    # 結果ファイルを読込む
    $resData = ComFunc::readResponseFile($conf{JSON_FILE}->{RESPONSE}, \%res_data);
    ComLog::log_output(ComLog::LOG_DEBUG, Dumper($resData));

    # リクエストファイルとレスポンスファイルを削除
    ComFunc::rmJsonFile($conf{JSON_FILE});

    # 結果を返す
    $header = $cgi->header(-type=>'application/json', -charset=>'UTF-8');
    ComFunc::setResponsData($resData, $header);

    # 終了ログ出力
    ComLog::log_output(ComLog::LOG_DEBUG, $messages{CM000D002});

    return $rc;
}
