#!/usr/bin/perl
#=======================================================================
# FileName : getWebRemoteControlerConfig.pl
# Summary  : Webリモコン設定取得API
# ----------------------------------------------------------------------
# DATE       NAME               REASON
# ---------- ------------------ ----------------------------------------
# 2015/02/24 Kiyoshi Oishi      Initial Release
#=======================================================================
use strict;
use CGI;
use JSON;
use Encode;
use Data::Dumper;

use lib '../com-lib';
use ComConst;
use ComFunc;
use CmdComFunc;
use ComLog;

my $rc = ComConst::STS_OK;

$rc = &main();

exit $rc;

#=======================================================================
# FuncName : main
# Summary  : Webリモコン設定取得メイン処理
# Argument : (IN)  $reqFile  : リクエストファイル名(scalar)
#          : (IN)  $resFile  : レスポンスファイル名(scalar)
# Return   : 正常:0, 異常:-1
# ----------------------------------------------------------------------
# DATE       NAME               REASON
# ---------- ------------------ ----------------------------------------
# 2015/02/24 Kiyoshi Oishi      Initial Release
#=======================================================================
sub main {
    my $rc = ComConst::STS_OK;
    my %conf = ();
    my %messages = ();
    my $cgi = new CGI;
    my %request = ();
    my %res_data = (ComConst::JSON_KEY_STS=>ComConst::STS_OK, ComConst::JSON_KEY_MSG=>"", ComConst::JSON_KEY_DAT=>());
    my $resData = "";
    my $header = "";

    # 初期化処理
    if ($rc == ComConst::STS_OK) {
        $rc = ComFunc::initializeApi($0, \%conf, \%messages);
    }

    # 開始ログ出力
    ComLog::log_output(ComLog::LOG_DEBUG, $messages{CM000D001});

    # リクエストデータの取得
    if ($rc == ComConst::STS_OK) {
        $rc = ComFunc::getRequestData(\$cgi, \%request);
        if ($rc != ComConst::STS_OK) {
                $res_data{ComConst::JSON_KEY_STS} = ComConst::STS_NG;
        }
    }

    # リクエストデータをファイルに出力
    if ($rc == ComConst::STS_OK) {
        # nothing
    }

    # コマンドを呼び出し
    if ($rc == ComConst::STS_OK) {
        my $requestData = decode_json("[" . $request{data} . "]");
        my $webRCConfigFileName = "";
        my $model = ComFunc::getAileunModelNumber();
        my $customLayoutUse = ComFunc::getAileunUseCustomLayout();
        my $displayRotate = ComFunc::getAileunDisplayRotate();

        # 製品によって読み込みの設定ファイルを変える
        if ($model == ComConst::AILEUN_MODEL_6) {
            if ($customLayoutUse eq ComConst::NO_USE_CUSTOM_LAYOUT) {
                if ($displayRotate eq ComConst::DISPLAY_ROTATE_NORMAL) {
                    # カスタムレイアウト使用なしかつ横表示
                    if ($requestData->[0]->{ProductKey} eq ComConst::NORMAL_CHANNEL36) {
                        $webRCConfigFileName = ComConst::CHANNEL36_WEB_RC_SEAMLESS_CONFIG;
                    }elsif ($requestData->[0]->{ProductKey} eq ComConst::NORMAL_CHANNEL16) {
                        $webRCConfigFileName = ComConst::CHANNEL16_WEB_RC_SEAMLESS_CONFIG;
                    }elsif ($requestData->[0]->{ProductKey} eq ComConst::NORMAL_CHANNEL9) {
                        $webRCConfigFileName = ComConst::CHANNEL9_WEB_RC_SEAMLESS_CONFIG;
                    }elsif ($requestData->[0]->{ProductKey} eq ComConst::NORMAL_CHANNEL4) {
                        $webRCConfigFileName = ComConst::CHANNEL4_WEB_RC_SEAMLESS_CONFIG;
                    }else {
                        $webRCConfigFileName = ComConst::CHANNEL9_WEB_RC_SEAMLESS_CONFIG;
                    }
                } else {
                    # カスタムレイアウト使用なしかつ縦表示
                    if ($requestData->[0]->{ProductKey} eq ComConst::NORMAL_CHANNEL36) {
                        $webRCConfigFileName = ComConst::CHANNEL36_WEB_RC_SEAMLESS_CONFIG;
                    }elsif ($requestData->[0]->{ProductKey} eq ComConst::NORMAL_CHANNEL16) {
                        $webRCConfigFileName = ComConst::CHANNEL16_WEB_RC_SEAMLESS_CONFIG;
                    }elsif ($requestData->[0]->{ProductKey} eq ComConst::NORMAL_CHANNEL9) {
                        $webRCConfigFileName = ComConst::CHANNEL9_WEB_RC_SEAMLESS_CONFIG;
                    }elsif ($requestData->[0]->{ProductKey} eq ComConst::NORMAL_CHANNEL4) {
                        $webRCConfigFileName = ComConst::CHANNEL4_WEB_RC_SEAMLESS_CONFIG;
                    }else {
                        $webRCConfigFileName = ComConst::CHANNEL9_WEB_RC_SEAMLESS_CONFIG;
                    }
                }
            } else {
                if ($displayRotate eq ComConst::DISPLAY_ROTATE_NORMAL) {
                    # カスタムレイアウト使用かつ横表示
                    if ($requestData->[0]->{ProductKey} eq ComConst::NORMAL_CHANNEL36) {
                        $webRCConfigFileName = ComConst::CHANNEL36_WEB_RC_SEAMLESS_CONFIG;
                    }elsif ($requestData->[0]->{ProductKey} eq ComConst::NORMAL_CHANNEL16) {
                        $webRCConfigFileName = ComConst::CHANNEL16_WEB_RC_SEAMLESS_CONFIG;
                    }elsif ($requestData->[0]->{ProductKey} eq ComConst::NORMAL_CHANNEL9) {
                        $webRCConfigFileName = ComConst::CHANNEL9_WEB_RC_SEAMLESS_CONFIG;
                    }elsif ($requestData->[0]->{ProductKey} eq ComConst::NORMAL_CHANNEL4) {
                        $webRCConfigFileName = ComConst::CHANNEL4_WEB_RC_SEAMLESS_CONFIG;
                    }else {
                        $webRCConfigFileName = ComConst::CHANNEL9_WEB_RC_SEAMLESS_CONFIG;
                    }
                } else {
                    # カスタムレイアウト使用かつ縦表示
                    if ($requestData->[0]->{ProductKey} eq ComConst::NORMAL_CHANNEL36) {
                        $webRCConfigFileName = ComConst::CHANNEL36_WEB_RC_SEAMLESS_CONFIG;
                    }elsif ($requestData->[0]->{ProductKey} eq ComConst::NORMAL_CHANNEL16) {
                        $webRCConfigFileName = ComConst::CHANNEL16_WEB_RC_SEAMLESS_CONFIG;
                    }elsif ($requestData->[0]->{ProductKey} eq ComConst::NORMAL_CHANNEL9) {
                        $webRCConfigFileName = ComConst::CHANNEL9_WEB_RC_SEAMLESS_CONFIG;
                    }elsif ($requestData->[0]->{ProductKey} eq ComConst::NORMAL_CHANNEL4) {
                        $webRCConfigFileName = ComConst::CHANNEL4_WEB_RC_SEAMLESS_CONFIG;
                    }else {
                        $webRCConfigFileName = ComConst::CHANNEL9_WEB_RC_SEAMLESS_CONFIG;
                    }
                }
            }
        } else {
            if ($requestData->[0]->{ProductKey} eq ComConst::NORMAL_CHANNEL36) {
                $webRCConfigFileName = ComConst::CHANNEL36_WEB_RC_SEAMLESS_CONFIG;
            } elsif ($requestData->[0]->{ProductKey} eq ComConst::NORMAL_CHANNEL16) {
                $webRCConfigFileName = ComConst::CHANNEL16_WEB_RC_SEAMLESS_CONFIG;
            } elsif ($requestData->[0]->{ProductKey} eq ComConst::NORMAL_CHANNEL9) {
                $webRCConfigFileName = ComConst::CHANNEL9_WEB_RC_SEAMLESS_CONFIG;
            } elsif ($requestData->[0]->{ProductKey} eq ComConst::NORMAL_CHANNEL4) {
                $webRCConfigFileName = ComConst::CHANNEL4_WEB_RC_SEAMLESS_CONFIG;
            } else {
                $webRCConfigFileName = ComConst::CHANNEL9_WEB_RC_SEAMLESS_CONFIG;
            }
        }
        # 設定ファイル読み込み
        my $webRCConfig = CmdComFunc::readRequestFile($webRCConfigFileName);
        $res_data{ComConst::JSON_KEY_DAT}{WRCConfig} = $webRCConfig;
    }
        
    # 結果ファイルを読込む
    $resData = decode_json(encode_json(\%res_data));
    ComLog::log_output(ComLog::LOG_DEBUG, Dumper($resData));

    # リクエストファイルとレスポンスファイルを削除
    ComFunc::rmJsonFile($conf{JSON_FILE});

    # 結果を返す
    $header = $cgi->header(-type=>'application/json', -charset=>'UTF-8');
    ComFunc::setResponsData($resData, $header);

    # 終了ログ出力
    ComLog::log_output(ComLog::LOG_DEBUG, $messages{CM000D002});

    return $rc;
}
