#!/usr/bin/perl
#=======================================================================
# FileName : loadSystemSettings.pl
# Summary  : 設定ロードAPI
# ----------------------------------------------------------------------
# DATE       NAME               REASON
# ---------- ------------------ ----------------------------------------
# 2014/04/24 Kiyoshi Oishi      Initial Release
#=======================================================================
use strict;
use CGI;
use JSON;
use Encode;
use File::Basename;
use File::Copy;
use Data::Dumper;
use File::Path 'make_path';

use lib '../com-lib';
use ComConst;
use ComFunc;
use CmdComFunc;
use ComLog;

my $rc = ComConst::STS_OK;

$rc = &main();

exit $rc;

#=======================================================================
# FuncName : main
# Summary  : 設定ロードメイン処理
# Argument : (IN)  $reqFile  : リクエストファイル名(scalar)
#          : (IN)  $resFile  : レスポンスファイル名(scalar)
# Return   : 正常:0, 異常:-1
# ----------------------------------------------------------------------
# DATE       NAME               REASON
# ---------- ------------------ ----------------------------------------
# 2014/04/24 Kiyoshi Oishi      Initial Release
#=======================================================================
sub main {
    my $rc = ComConst::STS_OK;
    my %conf = ();
    my %messages = ();
    my $cgi = new CGI;
    my %request = ();
    my %res_data = (ComConst::JSON_KEY_STS=>ComConst::STS_OK, ComConst::JSON_KEY_MSG=>"");
    my $resData = "";
    my $header = "";
    my $recvData;

    # 初期化処理
    if ($rc == ComConst::STS_OK) {
        $rc = ComFunc::initializeApi($0, \%conf, \%messages);
    }

    # 開始ログ出力
    ComLog::log_output(ComLog::LOG_DEBUG, $messages{CM000D001});


    # リクエストデータの取得
    if ($rc == ComConst::STS_OK) {
        # nothing
    }

    # リクエストデータをファイルに出力
    if ($rc == ComConst::STS_OK) {
        # nothing
    }

    # 機能制限チェック
    if ($rc == ComConst::STS_OK) {
        if (ComConst::STS_OK != CmdComFunc::existFile(ComConst::NOTIFY_FACTORY_DEFAULT)) {
            if (CmdComFunc::existWebFuncLimitFile() != ComConst::STS_OK) {
                $rc = ComConst::STS_NG;
                $res_data{ComConst::JSON_KEY_STS} = ComConst::STS_NG;
                $res_data{ComConst::JSON_KEY_MSG} = $messages{CM000E002} . "<br>" . $messages{CM000E003};
            }
        }
    }

    # コマンドを呼び出し
    if ($rc == ComConst::STS_OK) {
        # nothing
    }

    # リクエストファイルとレスポンスファイルを削除
    ComFunc::rmJsonFile($conf{JSON_FILE});

    # アップロードファイルを所定の場所に移動
    if ($rc == ComConst::STS_OK) {
        $rc = mvUploadFile($cgi);
        if ($rc != ComConst::STS_OK) {
            if ($rc == ComConst::CONFIG_CHK_ST_ARG_ERR) {
                $res_data{ComConst::JSON_KEY_MSG} = $messages{CM002E002};
            } elsif ($rc == ComConst::CONFIG_CHK_ST_UNZIP_ERR) {
                $res_data{ComConst::JSON_KEY_MSG} = $messages{CM002E003};
            } elsif ($rc == ComConst::CONFIG_CHK_ST_REQ_ERR) {
                $res_data{ComConst::JSON_KEY_MSG} = $messages{CM002E004} . "<br>" . $messages{CM002E005} . "<br>" . $messages{CM002E006};
            } else {
                $res_data{ComConst::JSON_KEY_MSG} = $messages{CM002E007};
            }
            $rc = ComConst::STS_NG;
        }
        $res_data{ComConst::JSON_KEY_STS} = $rc;
    }

    # 結果ファイルを読込む
    $resData = ComFunc::readResponseFile($conf{JSON_FILE}->{RESPONSE}, \%res_data);
    ComLog::log_output(ComLog::LOG_DEBUG, Dumper($resData));

    # 結果を返す
    $header = $cgi->header(-type=>'application/json', -charset=>'UTF-8');
    ComFunc::setResponsData($resData, $header);

    # 終了ログ出力
    ComLog::log_output(ComLog::LOG_DEBUG, $messages{CM000D002});

    return $rc;
}

#=======================================================================
# FuncName : mvUploadFile
# Summary  : ファイル移動
# Argument : (IN)  $cgi  : cgiオブジェクト(ref)
# Return   : 正常:0, 異常:-1
# ----------------------------------------------------------------------
# DATE       NAME               REASON
# ---------- ------------------ ----------------------------------------
# 2014/04/24 Kiyoshi Oishi      Initial Release
#=======================================================================
sub mvUploadFile {
    my $rc = ComConst::STS_OK;
    my $cgi = $_[0];
    my $file = "";
    # アップロードファイルのハンドル取得
    my $fh = $cgi->upload('file');
    my $tmp_file = "";
    my $model = ComFunc::getAileunModelNumber();

    # 取得できない場合はエラー
    if (!defined($fh)) {
        $rc = ComConst::STS_NG;
    }

    if ($rc == ComConst::STS_OK) {
        # 一時ファイルの場所
        $tmp_file = $cgi->tmpFileName($fh);
        # オリジナルのファイル名
        my $filename = ComConst::AILEUN4_CONFIG_ZIPFILE;
        if ($model == ComConst::AILEUN_MODEL_5) {
            $filename = ComConst::AILEUN5_CONFIG_ZIPFILE;
        } elsif ($model == ComConst::AILEUN_MODEL_6) {
            $filename = ComConst::AILEUN6_CONFIG_ZIPFILE;
        } elsif ($model == ComConst::AILEUN_MODEL_7) {
            $filename = ComConst::AILEUN7_CONFIG_ZIPFILE;
        } elsif ($model == ComConst::AILEUN_MODEL_8) {
            $filename = ComConst::AILEUN8_CONFIG_ZIPFILE;
        }

        # ファイルの保存場所
        #$file = "/tmp/" . $filename;
        # 3216 設定ファイルアップ後に、アプリに上書きされるので、タイミングを起動時に
        make_path("/opt/aile/uploaded");
        $file = "/opt/aile/uploaded/" . $filename;
        # ファイル移動
        if (!move($tmp_file, $file)) {
            $rc = ComConst::STS_NG;
        }
        close($fh);

        if ($rc == ComConst::STS_OK) {
            my $exec_cmd = "";
            if ($model == ComConst::AILEUN_MODEL_5) {
                $exec_cmd = sprintf(ComConst::AILEUN_CONFIG_CHK_CMD, ComConst::AILEUN5_CONFIG_ZIPFILE);
            } elsif ($model == ComConst::AILEUN_MODEL_6) {
                $exec_cmd = sprintf(ComConst::AILEUN_CONFIG_CHK_CMD, ComConst::AILEUN6_CONFIG_ZIPFILE);
            } elsif ($model == ComConst::AILEUN_MODEL_7) {
                $exec_cmd = sprintf(ComConst::AILEUN_CONFIG_CHK_CMD, ComConst::AILEUN7_CONFIG_ZIPFILE);
            } elsif ($model == ComConst::AILEUN_MODEL_8) {
                $exec_cmd = sprintf(ComConst::AILEUN_CONFIG_CHK_CMD, ComConst::AILEUN8_CONFIG_ZIPFILE);
            } else {
                $exec_cmd = sprintf(ComConst::AILEUN_CONFIG_CHK_CMD, ComConst::AILEUN4_CONFIG_ZIPFILE);
            }
            $rc = system($exec_cmd);
        }

        if ($rc == ComConst::STS_OK) {
            my $exec_cmd = "";
            $exec_cmd = ComConst::AILEUN_CONFIG_LOAD_CMD;
            $rc = system($exec_cmd);
        }
    }

    return $rc;
}
