#!/usr/bin/perl
#=======================================================================
# FileName : restartSystem.pl
# Summary  : 再起動API
# ----------------------------------------------------------------------
# DATE       NAME               REASON
# ---------- ------------------ ----------------------------------------
# 2014/04/30 Takashi Koizumi    Initial Release
#=======================================================================
use strict;
use CGI::Fast;
use JSON;
use File::Copy;
use Data::Dumper;

use lib '../com-lib';
use ComConst;
use CmdComFunc;
use ComFunc;
use ComLog;

my $rc = ComConst::STS_OK;

$rc = &main();

#=======================================================================
# FuncName : main
# Summary  : 再起動メイン処理
# Argument : (IN)  $reqFile  : リクエストファイル名(scalar)
#          : (IN)  $resFile  : レスポンスファイル名(scalar)
# Return   : 正常:0, 異常:-1
# ----------------------------------------------------------------------
# DATE       NAME               REASON
# ---------- ------------------ ----------------------------------------
# 2014/04/30 Takashi Koizumi    Initial Release
#=======================================================================
sub main {
    my $rc = ComConst::STS_OK;
    my %conf = ();
    my %messages = ();
    my $cgi = new CGI;
    my %request = ();
    my %res_data = (ComConst::JSON_KEY_STS=>ComConst::STS_OK, ComConst::JSON_KEY_MSG=>"");
    my $resData = "";
    my $header = "";

    # 初期化処理
    if ($rc == ComConst::STS_OK) {
        $rc = ComFunc::initializeApi($0, \%conf, \%messages);
    }

    # 開始ログ出力
    ComLog::log_output(ComLog::LOG_DEBUG, $messages{CM000D001});

    # リクエストデータの取得
    if ($rc == ComConst::STS_OK) {
        $rc = ComFunc::getRequestData(\$cgi, \%request);
        if ($rc != ComConst::STS_OK) {
            $res_data{ComConst::JSON_KEY_STS} = ComConst::STS_NG;
        }
    }

    # リクエストデータ
    ComLog::log_output(ComLog::LOG_DEBUG, Dumper(\%request));

    # リクエストデータをファイルに出力
    if ($rc == ComConst::STS_OK) {
        # nothing
    }
    
    # コマンドを呼び出し
    if ($rc == ComConst::STS_OK) {
        my $pid = fork();
        if($pid) {
            # 親プロセス
            if ($rc == ComConst::STS_OK) {
                # 親プロセスは、子プロセスの終了を待たずに終了する
                ComLog::log_output(ComLog::LOG_INFO, $messages{CM192I001});
            }
            # 結果ファイルを読込む
            $resData = ComFunc::readResponseFile($conf{JSON_FILE}->{RESPONSE}, \%res_data);
            ComLog::log_output(ComLog::LOG_DEBUG, Dumper($resData));

            # リクエストファイルとレスポンスファイルを削除
            ComFunc::rmJsonFile($conf{JSON_FILE});

            # 結果を返す
            $header = $cgi->header(-type=>'application/json', -charset=>'UTF-8');
            ComFunc::setResponsData($resData, $header);
        } else {
            # 子プロセスの処理
            # 標準出力を閉じないと、親プロセスが子プロセスを待つので閉じておく
            close(STDOUT);
            sleep(ComConst::SHUTDOWN_WAIT_TIME);
        }
    }

    # 終了ログ出力
    ComLog::log_output(ComLog::LOG_DEBUG, $messages{CM000D002});

    return $rc;
}
