#!/usr/bin/perl
#=======================================================================
# FileName : setAuthUserPasswd.pl
# Summary  : Authユーザー情報変更API
# ----------------------------------------------------------------------
# DATE       NAME               REASON
# ---------- ------------------ ----------------------------------------
# 2014/04/16 Kiyoshi Oishi      Initial Release
#=======================================================================
use strict;
use CGI;
use JSON;
use Encode;
use MIME::Base64;
use Data::Dumper;

use lib '../com-lib';
use ComConst;
use ComFunc;
use CmdComFunc;
use ComLog;

my $rc = ComConst::STS_OK;

$rc = &main();

exit $rc;

#=======================================================================
# FuncName : main
# Summary  : Authユーザー情報変更メイン処理
# Argument : Notthing
# Return   : 正常:0, 異常:< 0
# ----------------------------------------------------------------------
# DATE       NAME               REASON
# ---------- ------------------ ----------------------------------------
# 2014/04/16 Kiyoshi Oishi      Initial Release
#=======================================================================
sub main {
    my $rc = ComConst::STS_OK;
    my %conf = ();
    my %messages = ();
    my $cgi = new CGI;
    my %request = ();
    my %res_data = (ComConst::JSON_KEY_STS=>ComConst::STS_OK, ComConst::JSON_KEY_MSG=>"");
    my $header = "";
    my $resData = "";

    # 初期化処理
    if ($rc == ComConst::STS_OK) {
        $rc = ComFunc::initializeApi($0, \%conf, \%messages);
    }

    # 開始ログ出力
    ComLog::log_output(ComLog::LOG_DEBUG, $messages{CM000D001});

    # リクエストデータの取得
    if ($rc == ComConst::STS_OK) {
        $rc = ComFunc::getRequestData(\$cgi, \%request);
        if ($rc != ComConst::STS_OK) {
                $res_data{ComConst::JSON_KEY_STS} = ComConst::STS_NG;
        }
    }

    # リクエストデータ
    ComLog::log_output(ComLog::LOG_DEBUG, Dumper(\%request));

    # リクエストデータをファイルに出力
    if ($rc == ComConst::STS_OK) {
        # nothing
    }

    # 機能制限チェック
    if ($rc == ComConst::STS_OK) {
        if (CmdComFunc::existWebFuncLimitFile() != ComConst::STS_OK) {
                $rc = ComConst::STS_NG;
                $res_data{ComConst::JSON_KEY_STS} = ComConst::STS_NG;
                $res_data{ComConst::JSON_KEY_MSG} = $messages{CM000E002} . "<br>" . $messages{CM000E003};
        }
    }

    # コマンドを呼び出し
    if ($rc == ComConst::STS_OK) {
        my $requestData = decode_json("[" . $request{data} . "]");
        # リクエストデータ復号化
        if ($rc == ComConst::STS_OK) {
                $rc = DecodeRequestData($requestData->[0]);
                ComLog::log_output(ComLog::LOG_DEBUG, Dumper($requestData->[0]));
        }

        # 入力チェック
        if ($rc == ComConst::STS_OK) {
            $rc = CmdComFunc::checkReqData($requestData, \%res_data);
            if ($rc == ComConst::STS_OK) {
                # パスワード確認
                my $chkObj = [{
                    userPasswdEqual => $requestData->[0]->{userPasswd} . " = " . $requestData->[0]->{userPasswdConf}
                }];
                $rc = CmdComFunc::checkReqData($chkObj, \%res_data);
            }
            # ユーザー名チェック
            if ($rc == ComConst::STS_OK) {
                $rc = IsAvailableUserName($requestData->[0]->{userName});
                if ($rc != ComConst::STS_OK) {
                    $res_data{ComConst::JSON_KEY_STS} = ComConst::STS_NG;
                    $res_data{ComConst::JSON_KEY_MSG} = sprintf($messages{CM001E002}, $request{data}->{userName});
                }
            }
            if ($rc != ComConst::STS_OK) {
                ComLog::log_output(ComLog::LOG_ERROR, $res_data{ComConst::JSON_KEY_MSG});
                ComLog::log_output(ComLog::LOG_ERROR, $messages{CM000E001});
            }
        }
    }

    # 結果ファイルを読込む
    $resData = ComFunc::readResponseFile($conf{JSON_FILE}->{RESPONSE}, \%res_data);
    ComLog::log_output(ComLog::LOG_DEBUG, Dumper($resData));

    # リクエストファイルとレスポンスファイルを削除
    ComFunc::rmJsonFile($conf{JSON_FILE});

    # 結果を返す
    $header = $cgi->header(-type=>'application/json', -charset=>'UTF-8');
    ComFunc::setResponsData($resData, $header);

    # 終了ログ出力
    ComLog::log_output(ComLog::LOG_DEBUG, $messages{CM000D002});

    return $rc;
}

#=======================================================================
# FuncName : IsAvailableUserName
# Summary  : 利用可能ユーザー名チェック
# Argument : (IN)  $userName  : Basicユーザー名(scalar)
# Return   : 正常:0, 異常:-1
# ----------------------------------------------------------------------
# DATE       NAME               REASON
# ---------- ------------------ ----------------------------------------
# 2015/03/23 Kiyoshi Oishi      Initial Release
#=======================================================================
sub IsAvailableUserName {
    my $res = ComConst::STS_OK;
    my $userName = $_[0];
    my $fbnUsrs;

    $fbnUsrs = ComFunc::readJsonFile(ComConst::FORBIDDEN_BASIC_USERS);

    if (grep {$_ eq $userName} @{$fbnUsrs->{ForbiddenUserNames}}) {
        $res = ComConst::STS_NG;
    }
    return $res;
}

#=======================================================================
# FuncName : DecodeRequestData
# Summary  : リクエストデータ復号化
# Argument : (IN/OUT)  $requestData  : リクエストデータ(ref)
# Return   : 正常:0, 異常:-1
# ----------------------------------------------------------------------
# DATE       NAME               REASON
# ---------- ------------------ ----------------------------------------
# 2015/04/08 Kiyoshi Oishi      Initial Release
#=======================================================================
sub DecodeRequestData {
    my $res = ComConst::STS_OK;
    my $requestData = $_[0];
    my @decKeys = keys(%$requestData);
    my $tmpDecString = "";

    foreach my $decKey (@decKeys) {
        # Base64で符号化されたデータを復号する
        $tmpDecString = decode_base64($requestData->{$decKey});
        # 元データに余分なデータを付加しているのでそれを除去して戻す
        $requestData->{$decKey} = (split(/ /, $tmpDecString))[0]
    }

    return $res;
}
