#!/usr/bin/perl
#=======================================================================
# FileName : updateSystem.pl
# Summary  : システムアップデートAPI
# ----------------------------------------------------------------------
# DATE       NAME               REASON
# ---------- ------------------ ----------------------------------------
# 2014/04/24 Kiyoshi Oishi      Initial Release
#=======================================================================
use strict;
use CGI;
use JSON;
use Encode;
use File::Basename;
use File::Copy;
use Data::Dumper;

use lib '../com-lib';
use ComConst;
use ComFunc;
use CmdComFunc;
use ComLog;

my $rc = ComConst::STS_OK;

$rc = &main();

exit $rc;

#=======================================================================
# FuncName : main
# Summary  : システムアップデートメイン処理
# Argument : (IN)  $reqFile  : リクエストファイル名(scalar)
#          : (IN)  $resFile  : レスポンスファイル名(scalar)
# Return   : 正常:0, 異常:-1
# ----------------------------------------------------------------------
# DATE       NAME               REASON
# ---------- ------------------ ----------------------------------------
# 2014/04/24 Kiyoshi Oishi      Initial Release
#=======================================================================
sub main {
    my $rc = ComConst::STS_OK;
    my %conf = ();
    my %messages = ();
    my $cgi = new CGI;
    my %request = ();
    my %res_data = (ComConst::JSON_KEY_STS=>ComConst::STS_OK, ComConst::JSON_KEY_MSG=>"");
    my $resData = "";
    my $header = "";
    my $recvData;

    # 初期化処理
    if ($rc == ComConst::STS_OK) {
        $rc = ComFunc::initializeApi($0, \%conf, \%messages);
    }

    # 開始ログ出力
    ComLog::log_output(ComLog::LOG_DEBUG, $messages{CM000D001});

    # リクエストデータの取得
    if ($rc == ComConst::STS_OK) {
        # nothing
    }

    # リクエストデータをファイルに出力
    if ($rc == ComConst::STS_OK) {
        # nothing
    }

    # 機能制限チェック
    if ($rc == ComConst::STS_OK) {
        if (CmdComFunc::existWebFuncLimitFile() != ComConst::STS_OK) {
            $rc = ComConst::STS_NG;
            $res_data{ComConst::JSON_KEY_STS} = ComConst::STS_NG;
            $res_data{ComConst::JSON_KEY_MSG} = $messages{CM000E002} . "<br>" . $messages{CM000E003};
        }
    }
    
    # コマンドを呼び出し
    if ($rc == ComConst::STS_OK) {
        # nothing
    }

    # リクエストファイルとレスポンスファイルを削除
    ComFunc::rmJsonFile($conf{JSON_FILE});

    # アップロードファイルを所定の場所に移動
    if ($rc == ComConst::STS_OK) {
        $rc = mvUploadFile($cgi);
        if ($rc != ComConst::STS_OK) {
            if ($rc == ComConst::AILEUN_PKG_CHK_ST_ARG_ERR) {
                $res_data{ComConst::JSON_KEY_MSG} = $messages{CM003E002};
            } elsif($rc == ComConst::AILEUN_PKG_CHK_ST_VALIDATE_ERR) {
                # その他エラー
                $res_data{ComConst::JSON_KEY_MSG} = $messages{CM003E003};
            } else {
                $res_data{ComConst::JSON_KEY_MSG} = $messages{CM003E004};
            }
            $rc = ComConst::STS_NG;
        }
        $res_data{ComConst::JSON_KEY_STS} = $rc;
    }
    # 結果ファイルを読込む
    $resData = ComFunc::readResponseFile($conf{JSON_FILE}->{RESPONSE}, \%res_data);
    ComLog::log_output(ComLog::LOG_DEBUG, Dumper($resData));

    # 結果を返す
    $header = $cgi->header(-type=>'application/json', -charset=>'UTF-8');
    ComFunc::setResponsData($resData, $header);

    # 終了ログ出力
    ComLog::log_output(ComLog::LOG_DEBUG, $messages{CM000D002});

    return $rc;
}

#=======================================================================
# FuncName : mvUploadFile
# Summary  : ファイル移動
# Argument : (IN)  $cgi  : cgiオブジェクト(ref)
# Return   : 正常:0, 異常:-1
# ----------------------------------------------------------------------
# DATE       NAME               REASON
# ---------- ------------------ ----------------------------------------
# 2014/04/24 Kiyoshi Oishi      Initial Release
#=======================================================================
sub mvUploadFile {
    my $rc = ComConst::STS_OK;
    my $cgi = $_[0];
    my $file = "";
    # アップロードファイルのハンドル取得
    my $fh = $cgi->upload('file');

    # 取得できない場合はエラー
    if (!defined($fh)) {
        $rc = ComConst::STS_NG;
    }

    if ($rc == ComConst::STS_OK) {
        # 一時ファイルの場所
        my $tmp_file = $cgi->tmpFileName($fh);
        # オリジナルのファイル名
        my $filename = ComConst::AILEUN_PKG_FILE_NAME;
        # ファイルの保存場所
        $file = "/tmp/" . $filename;
        # ファイル移動
        if (!move($tmp_file, $file)) {
            $rc = ComConst::STS_NG;
        }
        close($fh);
        if ($rc == ComConst::STS_OK) {
            my $exec_cmd = sprintf(ComConst::AILEUN_PKG_CHK_CMD, ComConst::AILEUN_PKG_FILE_NAME);
            $rc = system($exec_cmd);
        }

        if ($rc == ComConst::STS_OK) {
            my $exec_cmd = ComConst::AILEUN_PKG_MV_CMD;
            $rc = system($exec_cmd);
        }
    }

    return $rc;
}
