#!/usr/bin/perl
#=======================================================================
# FileName : uploadAlarmSoundFile.pl
# Summary  : AlarmSoundアップロードAPI
# ----------------------------------------------------------------------
# DATE       NAME               REASON
# ---------- ------------------ ----------------------------------------
# 2021/11/08 Kiyoshi Oishi      Initial Release
#=======================================================================
use strict;
use CGI;
use JSON;
use Encode;
use File::Basename;
use File::Copy;
use Data::Dumper;

use lib '../com-lib';
use ComConst;
use ComFunc;
use CmdComFunc;
use ComLog;

my $rc = ComConst::STS_OK;

$rc = &main();

exit $rc;

#=======================================================================
# FuncName : main
# Summary  : AlarmSoundアップロードメイン処理
# Argument : (IN)  $reqFile  : リクエストファイル名(scalar)
#          : (IN)  $resFile  : レスポンスファイル名(scalar)
# Return   : 正常:0, 異常:-1
# ----------------------------------------------------------------------
# DATE       NAME               REASON
# ---------- ------------------ ----------------------------------------
# 2021/11/08 Kiyoshi Oishi      Initial Release
#=======================================================================
sub main {
    my $rc = ComConst::STS_OK;
    my %conf = ();
    my %messages = ();
    my $cgi = new CGI;
    my %request = ();
    my %res_data = (ComConst::JSON_KEY_STS=>ComConst::STS_OK, ComConst::JSON_KEY_MSG=>"");
    my $resData = "";
    my $header = "";
    my $recvData;

    # 初期化処理
    if ($rc == ComConst::STS_OK) {
        $rc = ComFunc::initializeApi($0, \%conf, \%messages);
    }

    # 開始ログ出力
    ComLog::log_output(ComLog::LOG_DEBUG, $messages{CM000D001});


    # リクエストデータの取得
    if ($rc == ComConst::STS_OK) {
        # nothing
    }

    # リクエストデータをファイルに出力
    if ($rc == ComConst::STS_OK) {
        # nothing
    }

    # 機能制限チェック
    if ($rc == ComConst::STS_OK) {
        if (CmdComFunc::existWebFuncLimitFile() != ComConst::STS_OK) {
            $rc = ComConst::STS_NG;
            $res_data{ComConst::JSON_KEY_STS} = ComConst::STS_NG;
            $res_data{ComConst::JSON_KEY_MSG} = $messages{CM000E002} . "<br>" . $messages{CM000E003};
        }
    }

    # コマンドを呼び出し
    if ($rc == ComConst::STS_OK) {
        # nothing
    }

    # リクエストファイルとレスポンスファイルを削除
    ComFunc::rmJsonFile($conf{JSON_FILE});

    # アップロードファイルを所定の場所に移動
    if ($rc == ComConst::STS_OK) {
        $rc = mvUploadFile($cgi);
        $res_data{ComConst::JSON_KEY_STS} = $rc;
    }
    # 結果ファイルを読込む
    $resData = ComFunc::readResponseFile($conf{JSON_FILE}->{RESPONSE}, \%res_data);
    ComLog::log_output(ComLog::LOG_DEBUG, Dumper($resData));

    # 結果を返す
    $header = $cgi->header(-type=>'application/json', -charset=>'UTF-8');
    ComFunc::setResponsData($resData, $header);

    # 終了ログ出力
    ComLog::log_output(ComLog::LOG_DEBUG, $messages{CM000D002});

    return $rc;
}

#=======================================================================
# FuncName : mvUploadFile
# Summary  : ファイル移動
# Argument : (IN)  $cgi  : cgiオブジェクト(ref)
# Return   : 正常:0, 異常:-1
# ----------------------------------------------------------------------
# DATE       NAME               REASON
# ---------- ------------------ ----------------------------------------
# 2021/11/08 Kiyoshi Oishi      Initial Release
#=======================================================================
sub mvUploadFile {
    my $rc = ComConst::STS_OK;
    my $cgi = $_[0];
    my $file = "";
    # アップロードファイルのハンドル取得
    my $fh = $cgi->upload('sound-file');
    my $tmp_file = "";

    # 取得できない場合はエラー
    if (!defined($fh)) {
        $rc = ComConst::STS_NG;
    }

    if ($rc == ComConst::STS_OK) {
        # 一時ファイルの場所
        $tmp_file = $cgi->tmpFileName($fh);
        # ファイルの保存場所
        $file = ComConst::ALARM_SOUND_CUSTOM_DIR . '/' . ComConst::ALARM_SOUND_CUSTOM_FILE;

        # ファイル移動
        if (!move($tmp_file, $file)) {
            ComLog::log_output(ComLog::LOG_ERROR, "Cannot move file. [$file]");
            $rc = ComConst::STS_NG;
        }
        close($fh);
        if ($rc == ComConst::STS_OK) {
            if (!chmod(0755, $file)) {
                $rc = ComConst::STS_NG;
            }
        }
        if ($rc == ComConst::STS_OK) {
            my $exec_cmd = sprintf(ComConst::ALARM_SOUND_CHOWN_CMD, "aile:aile", $file);
            if (system($exec_cmd)) {
                $rc = ComConst::STS_NG;
            }
        }
    }

    return $rc;
}
