package CmdValidator;
#=======================================================================
# FileName : CmdValidator.pm
# Summary  : 共通Validator
# ----------------------------------------------------------------------
# DATE       NAME               REASON
# ---------- ------------------ ----------------------------------------
# 2015/02/23 Kiyoshi Oishi      Initial Release
#=======================================================================
use strict;
use JSON;
use Encode;
use Data::Dumper;

use lib '../cgi-bin';
use ComLog;

use constant TRUE  => 1;
use constant FALSE => 0;

# Validate定義ファイル
our $validateFile = "../html/js/json/validate.json";
our $messageFile  = "../html/js/json/message.json";
our $kbnFile      = "../html/js/json/kbn.json";
our $validateConfig = "";
our $messageConfig  = "";
our $kbnConfig      = "";

our $result = {
    "state" => TRUE,
    "msg"   => [],
};

# チェック関数マッピング
our %memberValidateConfig = (
    'len'                => \&targetLength,
    'haneisukigo'        => \&isHaneisukigo,
    'haneisukigoP'       => \&isHaneisukigoPasswd,
    'num'                => \&isNum,
    'kbn'                => \&isKbn,
    'range'              => \&isRange,
    'format'             => \&isFormat,
    'isAssignedName'     => \&isAssignedName,
    'range'              => \&isRange,
    'isIpFormat'         => \&isIpFormat,
    'isNtpServer'        => \&isNtpServer,
    'isEqual'            => \&isEqual,
    'isNotEqual'         => \&isNotEqual,
    'isChanged'          => \&isChanged,
    'kbnMulti'           => \&kbnMulti,
    'forbbidden'         => \&isForbbidden,
    'hankaku'            => \&isHankaku,
    'forbbiddenInput'    => \&isForbbiddenInput,
    'forbbiddenInputSF'  => \&isForbbiddenInputSF,
    'forbbiddenInputPlus'=> \&isForbbiddenInputPlus,
    'hostFormat'         => \&isHostFormat,
    'ugFormat'           => \&isUGFormat,
    'zeroOver'           => \&isZeroOver,
    'isNumericAlpha'     => \&isNumericAlpha
);

# エラーメッセージコードマッピング
our %errMessageConfig = (
    'required'           => "MSG001",
    'len'                => "MSG002",
    'haneisukigo'        => "MSG003",
    'haneisukigoP'       => "MSG003",
    'num'                => "MSG004",
    'kbn'                => "MSG005",
    'range'              => "MSG006",
    'format'             => "MSG005",
    'isAssignedName'     => "MSG005",
    'isIpFormat'         => "MSG007",
    'isNtpServer'        => "MSG008",
    'isEqual'            => "MSG009",
    'isNotEqual'         => "MSG010",
    'isChanged'          => "MSG011",
    'kbnMulti'           => "MSG012",
    'forbbidden'         => "MSG013",
    'hankaku'            => "MSG014",
    'hostFormat'         => "MSG015",
    'ugFormat'           => "MSG016",
    'forbbiddenInput'    => "MSG017",
    'forbbiddenInputSF'  => "MSG020",
    'forbbiddenInputPlus'=> "MSG018",
    'zeroOver'           => "MSG021",
    'isNumericAlpha'     => "MSG022",
);

# validate処理
sub comValidator {
    my $requestArray = $_[0];

    # validate定義読み込み
    $validateConfig = &getJsonFile($validateFile);
    $messageConfig  = &getJsonFile($messageFile);
    $kbnConfig      = &getJsonFile($kbnFile);

    # 全項目チェック処理実行
    &allCheckFunction($requestArray);

    # 結果返却
    return $result;
}

# 全項目チェック処理
sub allCheckFunction {
    my $targetArray = $_[0];

    # target分ループ
    foreach my $arrayKey(keys(%$targetArray)) {
        # データ構造判定
        if (ref($targetArray->{$arrayKey}) eq "ARRAY") {
            # 配列の場合全項目チェック処理をループで呼び出し
            foreach my $val(@{$targetArray->{$arrayKey}}) {
                &allCheckFunction($val);
            }
        } elsif (ref($targetArray->{$arrayKey}) eq "HASH" ) {
            # ハッシュの場合全項目チェック処理呼び出し
            &allCheckFunction($targetArray->{$arrayKey});
        } elsif ($arrayKey ne "" ) {
            # 単項目チェック処理実行
            &singleCheckFunction($arrayKey, $targetArray->{$arrayKey});
        }
    }
}

# 単項目チェック処理
# 引数にはチェック対象カラムが格納されたハッシュを指定
sub singleCheckFunction {
    my $requestKey = $_[0];
    my $requestValue = $_[1];
    my $validateStr = "";
    my $requestName = "";
    my $index1 = 0;
    my $index2 = 0;
    my $funcName = "";
    my $funcArgs = "";
    my $msgCd = "";

    # カラム名から、チェック内容のvalidate内容を取得
    $validateStr = @$validateConfig{$requestKey}->{'validate'};

    # カラム名の日本語名称を取得
    $requestName = @$validateConfig{$requestKey}->{'errname'};

    # 必須チェックを行う
    if (@$validateConfig{$requestKey}->{'required'}) {
        if( $requestValue eq "" ) {
            # 必須エラー
            $result->{'state'} = FALSE;
            $msgCd = $errMessageConfig{'required'};
            push(@{$result->{'msg'}}, &getMessage($msgCd, $requestName));
            return ;
        }
    }

    # validateが空の場合、チェックしない
    if ($validateStr eq "") {
        return ;
    } else {
        # validate内容を配列に格納
        my @validateList = split(/,/, $validateStr);

        # 命令文字列分ループ
        foreach my $funcExpr(@validateList) {
            $funcName = $funcExpr;
            if (defined(@$validateConfig{$requestKey}->{$funcName})) {
                #my @tmpFuncArgs = split(/','/, @$validateConfig{$requestKey}->{$funcName});
                my $tmpFuncArgs = @$validateConfig{$requestKey}->{$funcName};
                if (ref($tmpFuncArgs) eq "ARRAY") {
                    for (my $idx = 0; $idx < @$tmpFuncArgs; $idx++) {
                        $tmpFuncArgs->[$idx] =~ s/^ +| +$//g;
                    }
                }
                $funcArgs = $tmpFuncArgs;
            }

            # サブルーチンを実行して結果を受け取る
            if (!$memberValidateConfig{$funcName}->($requestValue, $funcArgs)) {
                # エラーがあった場合、エラーメッセージ格納
                $result->{'state'} = FALSE;
                $msgCd = $errMessageConfig{$funcName};
                my @errMsgArgs;
                if (ref($funcArgs) eq "ARRAY") {
                    @errMsgArgs = split(/,/, "$requestName,". join(",", @$funcArgs));
                } else {
                    @errMsgArgs = split(/,/, "$requestName,$funcArgs");
                }
                push(@{$result->{'msg'}}, &getMessage($msgCd, \@errMsgArgs));
            }
        }
    }
    return;

}

# JSON定義ファイル読み込み
sub getJsonFile {
    my $targetFile = $_[0];
    my $json = "";
    my $data = "";

    open(FH, $targetFile);
    $json = do {
        local $/;
        <FH>
    };
    close(FH);

    $data = decode_json($json);

    return $data;
}

# メッセージ設定
sub getMessage {
    my $msgCd = $_[0];
    my $args  = $_[1];
    my $returnMsg = "";
    my $targetStr = "";
    my $argsStr   = "";

    my $message = $messageConfig->{$msgCd};

    if(!$message) {
        $returnMsg = sprintf("メッセージが未定義です[%s]",$msgCd);
    } else {

        # メッセージ置き換え
        if (ref($args) eq 'ARRAY') {
            for (my $i=0; $i < @$args ; $i++) {
                $targetStr = quotemeta(sprintf("{%s}",$i));
                $argsStr   = quotemeta($args->[$i]);
                $message =~s/$targetStr/$argsStr/;
            }
        } else {
            $message =~s/\{0\}/$args/;
        }
        $message =~ s/\\//g;
        $returnMsg = $message;
    }

    return $returnMsg;
}

# 数字かどうかチェック
sub isNum($) {
    my $target = $_[0];

    # 数値チェック
    if($target !~ /^[0-9]+$/) {
        return FALSE;
    }

    return TRUE;
}

# 半角英数チェック
sub isNumericAlpha($) {
    my $target = $_[0];
    my $args   = $_[1];

    if ($target !~ /^[a-zA-Z0-9]+$/) {
        return FALSE;
    }
    return TRUE;
}

# 文字列長チェック
sub targetLength($) {
    my $target = $_[0];
    my $length = $_[1];

    # 文字列長チェック
    if(length($target) > $length) {
        return FALSE;
    }

    return TRUE;
}

# 半角英数字記号チェック
sub isHaneisukigo($) {
    my $target = $_[0];
    my $symbols  = $_[1]; 
    my $pattern = "0-9a-zA-Z" . quotemeta($symbols);

    # 半角英数字記号チェック
    if($target !~ /^[$pattern]+$/) {
        return FALSE;
    }

    return TRUE;
}

# 半角英数字記号チェック
sub isHaneisukigoPasswd($) {
    my $target = $_[0];
    my $symbols  = $_[1];
    my $pattern = "0-9a-zA-Z" . quotemeta($symbols);

    # 半角英数字記号チェック
    if($target !~ /^[$pattern]+$/) {
        return FALSE;
    }

    return TRUE;
}

# 区分値チェック
sub isKbn($) {
    my $target = $_[0];
    my $kbn    = $_[1];

    # 区分値チェック
    if(!grep {$_ eq $target} @{$kbnConfig->{$kbn}}) {
        return FALSE;
    }

    return TRUE;
}

sub isRange($) {
    my $target = $_[0];
    my $range  = $_[1];

    # 文字列長チェック
    if (length($target) < $range->[0] || length($target) > $range->[1]) {
        return FALSE;
    }
    return TRUE;
}

# フォーマットチェック
sub isFormat($) {
    my $target = $_[0];
    my $symbols  = $_[1]; 
    my $pattern = $symbols;

    # 半角英数字記号チェック
    if($target !~ /$pattern/) {
        return FALSE;
    }

    return TRUE;
}

# 所属名フォーマットチェック
sub isAssignedName($) {
    my $target = $_[0];

    # 半角英数字記号チェック
    if($target !~ /^[0-9a-zA-Z!#\$%&'()\-\.\/@\[\]\^_`\{\}~]+$/) {
        return FALSE;
    }

    return TRUE;
}

sub isIpFormat {
    my $target = $_[0];

    if ($target !~ /^(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])$/) {
        return FALSE;
    }
    return TRUE
}

sub isNtpServer {
    my $target = $_[0];

    if ($target !~ /^([0-9a-zA-Z]+\.)+[a-zA-Z]+$|^([0-9a-zA-Z][0-9a-zA-Z-]{1,61}[0-9a-zA-Z]\.)+[a-zA-Z\.]+$/) {
        if (!isIpFormat($target)) {
            return FALSE;
        }
    }
    return TRUE
}

sub isEqual {
    my $target = $_[0];

    my @values = split(/ = /, $target);
    if ($values[0] ne $values[1]) {
        return FALSE;
    }
    return TRUE;
}

sub isNotEqual {
    my $target = $_[0];

    my @values = split(/ = /, $target);
    if ($values[0] eq $values[1]) {
        return FALSE;
    }
    return TRUE;
}

sub isChanged {
    my $target = $_[0];

    my @values = split(/ = /, $target);
    if ($values[0] eq $values[1]) {
        return FALSE;
    }
    return TRUE;
}

sub kbnMulti {
    my $target = $_[0];
    my $kbn    = $_[1];
    my @values = split(/,/, $target);
    my $rc = TRUE;

    # 区分値チェック
    foreach my $value (@values) {
        if(!grep {$_ eq $value} @{$kbnConfig->{$kbn}}) {
            $rc = FALSE;
        }
    }

    return $rc;
}

sub isForbbidden {
    my $target = $_[0];
    my $args   = $_[1];
    my $rc     = TRUE;

    # 文字列長チェック
    foreach my $arg (@$args) {
        if ($target =~ /^$arg$/i) {
            $rc = FALSE;
            last;
        }
    }
    return $rc;
}

sub isHankaku {
    my $target = $_[0];
    my $args   = $_[1];

    if ($target =~ /^[\x20-\x7E]+$/) {
        return TRUE;
    }
    return FALSE;
}

sub isForbbiddenInput {
    my $target = $_[0];
    my $args   = $_[1];

    if ($target =~ /["\\]/g) {
        return FALSE;
    }
    return TRUE;
}

sub isForbbiddenInputSF {
    my $target = $_[0];
    my $args   = $_[1];

    if ($target =~ /[\/"\\]/g) {
        return FALSE;
    }
    return TRUE;
}

sub isForbbiddenInputPlus {
    my $target = $_[0];
    my $args   = $_[1];

    if ($target =~ /["&=\\]/g) {
        return FALSE;
    }
    return TRUE;
}

sub isHostFormat {
    my $target = $_[0];
    my $args   = $_[1];

    if ($target =~ /^[0-9a-zA-Z]+$|^[0-9a-zA-Z][0-9a-zA-Z-]+[0-9a-zA-Z]$/) {
        return TRUE;
    }
    return FALSE;
}

sub isUGFormat {
    my $target = $_[0];
    my $args   = $_[1];

    if ($target =~ /^[a-zA-Z]([0-9a-zA-Z\-._])*[0-9a-zA-Z\-._]$/) {
        return TRUE;
    }
    return FALSE;
}

sub isZeroOver {
    my $target = $_[0];
    my $args   = $_[1];

    if ($target > 0) {
        return TRUE;
    }
    return FALSE;
}

1;
