#!/usr/bin/perl
package ComConst;
#=======================================================================
# FileName : ComConst.pm
# Summary  : 共通定義
# ----------------------------------------------------------------------
# DATE       NAME               REASON
# ---------- ------------------ ----------------------------------------
# 2015/02/23 Kiyoshi Oishi      Initial Release
#=======================================================================
use strict;

use constant EXEC_SYSTEM => '1';

use constant REQUEST_PATH => '../tmp';
use constant RESPONSE_PATH => '../tmp';
use constant BASE_CMD_PATH => '../bin';
use constant DATA_DIR_PATH => '../data';
use constant CONF_PATH => '../conf';
use constant MSG_PATH => '../conf/Locale/';

use constant JSON_KEY_STS => 'status';
use constant JSON_KEY_MSG => 'message';
use constant JSON_KEY_DAT => 'data';

use constant RETRY_CNT => 3;
use constant SLEEP_TIME => 1;

use constant ENCODINGS => 'utf8';

use constant NON_SETTING => "-";
use constant DEFAULT_DATE_FORMAT => '%04d%02d%02d%02d%02d%02d';

use constant DISPLAY => ":0.0";

use constant SHUTDOWN_WAIT_TIME => 5;

##### ステータス #####
use constant STS_OK =>  0;
use constant STS_NG => -1;
use constant STS_ERR_SES => -11;
use constant STS_ERR_FILE => -2;

##### Aileun #####
use constant AILEUN_MODEL_4 => 4;
use constant AILEUN_MODEL_5 => 5;
use constant AILEUN_MODEL_6 => 6;
use constant AILEUN_MODEL_7 => 7;
use constant AILEUN_MODEL_8 => 8;
use constant AILEUN_VERSION_FILE => '/opt/aile/version.txt';
use constant SEAMLESS_VIEWER_CONFIG => '/opt/aile/config/ViewerSeamlessConfig.conf';
use constant AILEUN_VIEW_SETTING_CONFIG => '/opt/aile/config/ViewerSetting.conf';
use constant AILEUN_DISPLAY_ROTATE_CONFIG => '/opt/aile/config/DisplayRotate.conf';
use constant GET_AILEUN_VERSION_CMD => 'head -n 1 %s';
use constant GET_AILEUN_MODELNO_CMD => 'head -n 1 %s | awk -F. \'{print $1\'}';
use constant GET_AILEUN_CUSTOM_LAYOUT_USE_CMD => 'cat %s | grep CustomLayoutUse | awk -F":" \'{print $2}\'';
use constant GET_AILEUN_DISPLAY_ROTATE_CMD => 'cat %s | awk -F"_" \'{print $2}\'';
use constant AILEUN_PRDCTNO_FILE => '/tmp/prdx2wr';
use constant GET_AILEUN_PRDCTNO_CMD => 'head -n 1 %s';
use constant SPECIAL_CONFIG_N => "";
use constant CMPRESS_AILEUN_CONFIG_CMD => '../bin/cmpressAileunConfigFiles.sh %s';
use constant AILEUN4_CONFIG_ZIPFILE => 'aileun_4.zip';
use constant AILEUN5_CONFIG_ZIPFILE => 'aileun_5.zip';
use constant AILEUN6_CONFIG_ZIPFILE => 'aileun_6.zip';
use constant AILEUN7_CONFIG_ZIPFILE => 'aileun_7.zip';
use constant AILEUN8_CONFIG_ZIPFILE => 'aileun_8.zip';
use constant ALARM_SOUND_CUSTOM_DIR => '/opt/aile/snd/alarm';
use constant ALARM_SOUND_CUSTOM_FILE => 'http_alarm_sound_custom.wav';
use constant ALARM_SOUND_CHOWN_CMD => 'sudo chown %s %s';
use constant AILE_CONFIG_DIR => '/opt/aile/config/';
use constant AILEUN_CONFIG_CHK_CMD => '../bin/validateAileunConfigFile.sh %s';
use constant CONFIG_CHK_ST_ARG_ERR => 256;
use constant CONFIG_CHK_ST_UNZIP_ERR => 512;
use constant CONFIG_CHK_ST_REQ_ERR => 768;
use constant AILEUN_CONFIG_LOAD_CMD => '../bin/uncmpressAileunConfigFile.sh';
use constant AILEUN_PKG_FILE_NAME => 'aile.tar.gz';
use constant AILEUN_PKG_CHK_ST_ARG_ERR => 256;
use constant AILEUN_PKG_CHK_ST_VALIDATE_ERR => 1280;
use constant AILEUN_PKG_CHK_CMD => '../bin/validateAileunUpdatePackage.sh %s';
use constant AILEUN_PKG_MV_CMD => '../bin/mvAileunUpdatePackage.sh';
use constant CMPRESS_AILEUN_LOG_CMD => '../bin/cmpressAileunBackuplog.sh %s';
use constant NORMAL_CHANNEL36 => '36';
use constant NORMAL_CHANNEL16 => '16';
use constant NORMAL_CHANNEL12 => '12';
use constant NORMAL_CHANNEL9 => '9';
use constant NORMAL_CHANNEL8 => '8';
use constant NORMAL_CHANNEL4 => '4';
use constant CHANNEL16_WEB_RC_CONFIG => '../conf/16ChannelWebRemoteContolerConfig.conf';
use constant CHANNEL12_WEB_RC_CONFIG => '../conf/12ChannelWebRemoteContolerConfig.conf';
use constant CHANNEL9_WEB_RC_CONFIG => '../conf/9ChannelWebRemoteContolerConfig.conf';
use constant CHANNEL8_WEB_RC_CONFIG => '../conf/8ChannelWebRemoteContolerConfig.conf';
use constant CHANNEL4_WEB_RC_CONFIG => '../conf/4ChannelWebRemoteContolerConfig.conf';
use constant CHANNEL36_WEB_RC_SEAMLESS_CONFIG => '../conf/36ChannelWebRemoteContolerConfigSeamless.conf';
use constant CHANNEL16_WEB_RC_SEAMLESS_CONFIG => '../conf/16ChannelWebRemoteContolerConfigSeamless.conf';
use constant CHANNEL12_WEB_RC_SEAMLESS_CONFIG => '../conf/12ChannelWebRemoteContolerConfigSeamless.conf';
use constant CHANNEL9_WEB_RC_SEAMLESS_CONFIG => '../conf/9ChannelWebRemoteContolerConfigSeamless.conf';
use constant CHANNEL8_WEB_RC_SEAMLESS_CONFIG => '../conf/8ChannelWebRemoteContolerConfigSeamless.conf';
use constant CHANNEL4_WEB_RC_SEAMLESS_CONFIG => '../conf/4ChannelWebRemoteContolerConfigSeamless.conf';
# カスタムレイアウト使用なし&横表示
use constant CHANNEL36_WRC_NN_CONFIG => '../conf/36WRConfigNoCustomNormal.conf';
use constant CHANNEL16_WRC_NN_CONFIG => '../conf/16WRConfigNoCustomNormal.conf';
use constant CHANNEL9_WRC_NN_CONFIG => '../conf/9WRConfigNoCustomNormal.conf';
use constant CHANNEL4_WRC_NN_CONFIG => '../conf/4WRConfigNoCustomNormal.conf';
# カスタムレイアウト使用なし&縦表示
use constant CHANNEL36_WRC_NV_CONFIG => '../conf/36WRConfigNoCustomVertical.conf';
use constant CHANNEL16_WRC_NV_CONFIG => '../conf/16WRConfigNoCustomVertical.conf';
use constant CHANNEL9_WRC_NV_CONFIG => '../conf/9WRConfigNoCustomVertical.conf';
use constant CHANNEL4_WRC_NV_CONFIG => '../conf/4WRConfigNoCustomVertical.conf';
# カスタムレイアウト使用&横表示
use constant CHANNEL36_WRC_UN_CONFIG => '../conf/36WRConfigCustomNormal.conf';
use constant CHANNEL16_WRC_UN_CONFIG => '../conf/16WRConfigCustomNormal.conf';
use constant CHANNEL9_WRC_UN_CONFIG => '../conf/9WRConfigCustomNormal.conf';
use constant CHANNEL4_WRC_UN_CONFIG => '../conf/4WRConfigCustomNormal.conf';
# カスタムレイアウト使用&縦表示
use constant CHANNEL36_WRC_UV_CONFIG => '../conf/36WRConfigCustomVertical.conf';
use constant CHANNEL16_WRC_UV_CONFIG => '../conf/16WRConfigCustomVertical.conf';
use constant CHANNEL9_WRC_UV_CONFIG => '../conf/9WRConfigCustomVertical.conf';
use constant CHANNEL4_WRC_UV_CONFIG => '../conf/4WRConfigCustomVertical.conf';

use constant AILEUN_SEND_MSG => 'id:%s,action:%s,view_no:%s,data:%s,auth:%s';
use constant FORBIDDEN_BASIC_USERS => '../conf/forbiddenUserNameList.json';
use constant FUNC_LIMITED_FILE => '/tmp/.LimitedWebFunc';

use constant HTTP_ALARM_SOCK_PATH => '/tmp/http_alarm.sock';
use constant HTTP_ALARM_DATATEMPLATE => '{"ViewCH":"$<ViewCH>"}';
our $HTTP_REQUEST_KEYS = {
    "ViewCH" => {"range"=>[1, 36]}
};

our $ALARM_CTRL_REQUEST_KEYS = {
    "title" => {"required"=>0, "length"=>15},
    "msg1" => {"required"=>1, "length"=>25},
    "msg2" => {"required"=>0, "length"=>25},
    "date" => {"required"=>0, "length"=>16, "pattern"=>"[0-9 :/]+"},
    "comment" => {"required"=>0, "length"=>15},
    "fontsize" => {"required"=>0, "list"=>[1, 2, 3]},
    "fontcolor" => {"required"=>0, "list"=>[1, 2, 3, 4, 5, 6, 7, 8]},
    "bgcolor" => {"required"=>0, "list"=>[1, 2, 3, 4, 5, 6, 7, 8]},
};

use constant TYPEKEYSYS => "sys";
use constant TYPEKEYINQ => "inq";
use constant SENDKEYNUM => "Num";
use constant SENDKEYCUR => "Cursor";
use constant SENDKEYFOCUS => "Focus";
use constant SENDKEYZOOM => "Zoom";
use constant SENDKEYPANTILT => "PanTilt";
use constant SENDKEYPOWER => "Power";
use constant SENDKEYVIEWLAYOUT => "Viewlayout";

use constant SYSKEYNUMDATATEMPLATE => '{"btnId":"%s", "reqType":"key%d", "targetView":-999, "reqData":""}';
use constant SYSKEYCURDATATEMPLATE => '{"btnId":"%s", "reqType":"keyCur%s", "targetView":-999, "reqData":""}';
use constant SYSKEYOTHERDATATEMPLATE => '{"btnId":"%s", "reqType":"key%s", "targetView":-999, "reqData":""}';
use constant INQKEYDATATEMPLATE => '{"btnId":"%s", "reqType":"%s", "targetView":-999, "reqData":"", "auth":"%s"}';
use constant INQCAMKEYDATATEMPLATE => '{"btnId":"%s", "reqType":"VIEW_SWITCHING", "targetView":%d, "reqData":"", "auth":"%s"}';
use constant INQLAYOUTDATATEMPLATE => '{"btnId":"%s", "reqType":"LAYOUTSWITCH", "targetView":%d, "reqData":"%d", "auth":"%s"}';
use constant INQLALARMCTLDATATEMPLATE => '{"btnId":"-999", "reqType":"ALARMCTL", "targetView":-999, "reqData":"%s", "auth":"%s"}';
use constant INQLALARMCTLDELDATATEMPLATE => '{"btnId":"-999", "reqType":"ALARMCTLDEL", "targetView":-999, "reqData":"%s", "auth":"%s"}';

use constant NO_USE_CUSTOM_LAYOUT => 0;
use constant USE_CUSTOM_LAYOUT => 1;
use constant DISPLAY_ROTATE_NORMAL => 'normal';
use constant DISPLAY_ROTATE_VERTICAL => 'vertical';

# WEB-AILEUN間通信リクエストチェック
our $RequiredRequestParams = {
    "sys" => {
        "Num"    => {"required"=>["type", "sendkey", "value"], "value_param_key"=>"value", "format"=>"", "validate_data_func"=>"isNumValidValue", "defineValueKeyName"=>"", "template"=>SYSKEYNUMDATATEMPLATE},
        "Camnum" => {"required"=>["type", "sendkey", "value"], "value_param_key"=>"value", "format"=>"", "validate_data_func"=>"isCamNumValidValue", "defineValueKeyName"=>"", "template"=>SYSKEYNUMDATATEMPLATE},
        "Cursor" => {"required"=>["type", "sendkey", "value"], "value_param_key"=>"value", "format"=>"%04b", "validate_data_func"=>"isDefinedValue", "defineValueKeyName"=>"CursorKey", "template"=>SYSKEYCURDATATEMPLATE},
        "Left"   => {"required"=>["type", "sendkey"], "value_param_key"=>"sendkey", "format"=>"", "validate_data_func"=>"", "defineValueKeyName"=>"", "template"=>SYSKEYOTHERDATATEMPLATE},
        "Enter"  => {"required"=>["type", "sendkey"], "value_param_key"=>"sendkey", "format"=>"", "validate_data_func"=>"", "defineValueKeyName"=>"", "template"=>SYSKEYOTHERDATATEMPLATE},
        "Menu"   => {"required"=>["type", "sendkey"], "value_param_key"=>"sendkey", "format"=>"", "validate_data_func"=>"", "defineValueKeyName"=>"", "template"=>SYSKEYOTHERDATATEMPLATE},
        "Aster"  => {"required"=>["type", "sendkey"], "value_param_key"=>"sendkey", "format"=>"", "validate_data_func"=>"", "defineValueKeyName"=>"", "template"=>SYSKEYOTHERDATATEMPLATE},
        "Clear"  => {"required"=>["type", "sendkey"], "value_param_key"=>"sendkey", "format"=>"", "validate_data_func"=>"", "defineValueKeyName"=>"", "template"=>SYSKEYOTHERDATATEMPLATE},
        "Movie"  => {"required"=>["type", "sendkey", "value"], "value_param_key"=>"value", "format"=>"%04b", "validate_data_func"=>"", "defineValueKeyName"=>"PlayOperateKey", "template"=>SYSKEYOTHERDATATEMPLATE},
        "Preset" => {"required"=>["type", "sendkey"], "value_param_key"=>"sendkey", "format"=>"", "validate_data_func"=>"", "defineValueKeyName"=>"", "template"=>SYSKEYOTHERDATATEMPLATE},
        "Split" => {"required"=>["type", "sendkey", "value"], "value_param_key"=>"value", "format"=>"%04b", "validate_data_func"=>"", "defineValueKeyName"=>"ViewSplitKey", "template"=>SYSKEYOTHERDATATEMPLATE},
    },
    "inq" => {
        "Camnum" => {"required"=>["type", "sendkey", "value"], "option_param"=>[], "value_param_key"=>"value", "format"=>"", "validate_data_func"=>"isCamNumValidValue", "defineValueKeyName"=>"", "validate_option_func"=>{}, "template"=>INQCAMKEYDATATEMPLATE},
        "Focus"   => {"required"=>["type", "sendkey", "value"], "option_param"=>[], "value_param_key"=>"value", "format"=>"", "validate_data_func"=>"isDefinedValue", "defineValueKeyName"=>"FocusKey", "validate_option_func"=>{}, "template"=>INQKEYDATATEMPLATE},
        "Zoom"    => {"required"=>["type", "sendkey", "value"], "option_param"=>[], "value_param_key"=>"value", "format"=>"", "validate_data_func"=>"isDefinedValue", "defineValueKeyName"=>"ZoomKey", "validate_option_func"=>{}, "template"=>INQKEYDATATEMPLATE},
        "Pantilt" => {"required"=>["type", "sendkey", "value"], "option_param"=>[], "value_param_key"=>"value", "format"=>"%04b", "validate_data_func"=>"isDefinedValue", "defineValueKeyName"=>"PanTiltKey", "validate_option_func"=>{}, "template"=>INQKEYDATATEMPLATE},
        "Power"   => {"required"=>["type", "sendkey", "value"], "option_param"=>[], "value_param_key"=>"value", "format"=>"", "validate_data_func"=>"isDefinedValue", "defineValueKeyName"=>"PowerKey", "validate_option_func"=>{}, "template"=>INQKEYDATATEMPLATE},
        ## オプションパラメータ名がviewだけど、入ってくるのはページ番号
        "Viewlayout" => {"required"=>["type", "sendkey", "value"], "option_param"=>["view"], "value_param_key"=>"value", "format"=>"", "validate_data_func"=>"isDefinedValue", "defineValueKeyName"=>"LayoutKey", "validate_option_func"=>{"view"=>"isNumeric"}, "template"=>INQLAYOUTDATATEMPLATE},
    }
};

our $HwType2CamNum = {
    "AS8004-AR"  => 4,
    "AS8009-A"   => 9,
    "AS8009-AM"  => 9,
    "AS8009-AR"  => 9,
    "AS8009-AMR" => 9,
    "AS8016-A"   => 16,
    "AS8016-AM"  => 16,
    "AS8036-A"   => 36,
    "AS8036-AM"  => 36,
};

our $Product2HwType = {
    "DS30N"      => "AS8009-AMR",
    "AS-8004AR"  => "AS8004-AR",
    "AS-8009A"   => "AS8009-A",
    "AS-8009AM"  => "AS8009-AM",
    "AS-8009AR"  => "AS8009-AR",
    "AS-8009AMR" => "AS8009-AMR",
    "AS-8016A"   => "AS8016-A",
    "AS-8016AM"  => "AS8016-AM",
    "AS-8036A"   => "AS8036-A",
    "AS-8036AM"  => "AS8036-AM",
};

use constant NOTIFY_FACTORY_DEFAULT => '/tmp/notify.factory.default';

1;
