#!/usr/bin/perl
package ComKeyConf;
#=======================================================================
# FileName : ComKeyConf.pm
# Summary  : キーイベント共通定義
# ----------------------------------------------------------------------
# DATE       NAME               REASON
# ---------- ------------------ ----------------------------------------
# 2015/03/09 Kiyoshi Oishi      Initial Release
#=======================================================================
use strict;

# 各ボタンがクリックされた時に発行するキーコード
our $RemoconKeyCode = {
    key1        => [["10"]],
    key2        => [["11"]],
    key3        => [["12"]],
    key4        => [["13"]],
    key5        => [["14"]],
    key6        => [["15"]],
    key7        => [["16"]],
    key8        => [["17"]],
    key9        => [["18"]],
    key0        => [["19"]],
    key10       => [["63", "19"]],
    key11       => [["63", "10"]],
    key12       => [["63", "11"]],
    key13       => [["63", "12"]],
    key14       => [["63", "13"]],
    key15       => [["63", "14"]],
    key16       => [["63", "15"]],
    key17       => [["63", "16"]],
    key18       => [["63", "17"]],
    key19       => [["63", "18"]],
    key20       => [["63", "63", "19"]],
    key21       => [["63", "63", "10"]],
    key22       => [["63", "63", "11"]],
    key23       => [["63", "63", "12"]],
    key24       => [["63", "63", "13"]],
    key25       => [["63", "63", "14"]],
    key26       => [["63", "63", "15"]],
    key27       => [["63", "63", "16"]],
    key28       => [["63", "63", "17"]],
    key29       => [["63", "63", "18"]],
    key30       => [["63", "63", "63", "19"]],
    key31       => [["63", "63", "63", "10"]],
    key32       => [["63", "63", "63", "11"]],
    key33       => [["63", "63", "63", "12"]],
    key34       => [["63", "63", "63", "13"]],
    key35       => [["63", "63", "63", "14"]],
    key36       => [["63", "63", "63", "15"]],
    keyEnter    => [["36"]],
    keyClear    => [["22"]],
    keyCurRight => [["114"]],
    keyCurLeft  => [["113"]],
    keyCurDown  => [["116"]],
    keyCurUp    => [["111"]],
    keyMenu     => [["67"]],
    keyPreset   => [["73"]],
    keyChUp     => [["95"]],
    keyChDown   => [["96"]],
    keyPlay     => [["73"]],
    keyPause    => [["70"]],
    keyRec      => [["69"]],
    keyFf       => [["74"]],
    keyRev      => [["72"]],
    keyStop     => [["71"]],
    keyMute     => [["68"]],
    keyVolUp    => [["75"]],
    keyVolDown  => [["76"]],
    keyLeft     => [["9"]],
    keyAster    => [["63"]]
};

our $AileWebCmdComKey = {
    "CursorKey" => {
        "0001"=>"Up",
        "1000"=>"Right",
        "0010"=>"Down",
        "0100"=>"Left"
    },
    "ViewSplitKey" => {
        "0100"=>"Ff",
        "0101"=>"Rev",
    },
    "PlayOperateKey" => {
        "0001"=>"Play",
        "0010"=>"Pause",
        "0011"=>"Rec",
        "0100"=>"Ff",
        "0101"=>"Rev",
        "0110"=>"Stop"
    },
    "FocusKey" => {
        "-1"=>"FOCUS_BACKWARD",
        "0"=>"AUTO_FOCUS",
        "1"=>"FOCUS_FORWARD"
    },
    "ZoomKey" => {
        "-1"=>"ZOOM_NARROW",
        "1"=>"ZOOM_WIDE"
    },
    "PanTiltKey" => {
        "0001"=>"CAMERA_TILT_UP",
        "1000"=>"CAMERA_PAN_RIGHT",
        "0010"=>"CAMERA_TILT_DOWN",
        "0100"=>"CAMERA_PAN_LEFT"
    },
    "PowerKey" => {
        "0"=>"PUSH_BUTTON_POWER"
    },
    "LayoutKey" => {
        "H02A"=>"1",
        "H04A"=>"2",
        "H06A"=>"3",
        "H06B"=>"4",
        "H08A"=>"5",
        "H09A"=>"6",
        "H12A"=>"7",
        "H16A"=>"8",
        "HCuA"=>"11",
        "V02A"=>"9",
        "V08A"=>"10",
        "VCuA"=>"12"
    },
};
# キーコード送信コマンド
use constant KEYPUSH_CMD => 'xsendkeycode %s 1 2>/dev/null;xsendkeycode %s 0 2>/dev/null;';

1;
