#!/usr/bin/perl
package ComKeyEventFunc;
#=======================================================================
# FileName : ComKeyEventFunc.pm
# Summary  : キーイベント共通メソッド
# ----------------------------------------------------------------------
# DATE       NAME               REASON
# ---------- ------------------ ----------------------------------------
# 2015/03/09 Kiyoshi Oishi      Initial Release
#=======================================================================
use strict;
use Data::Dumper;
use Sys::Syslog;
use Time::HiRes qw(usleep);

use ComKeyConf;
use ComLog;

#=======================================================================
# FuncName : sendKeyCode
# Summary  : リクエストされたWebリモコンの値をシステムに送信する
# Argument : (IN) $data     : リクエストデータ(ref_hash)
# Return   : Nothing
# ----------------------------------------------------------------------
# DATE       NAME               REASON
# ---------- ------------------ ----------------------------------------
# 2015/03/09 Kiyoshi Oishi      Initial Release
#=======================================================================
sub sendKeyCode {
    my $data = $_[0];
    my $exec_cmd = "";
    my $firstFlg = 1;

    my $keyConf = $ComKeyConf::RemoconKeyCode->{$data->{reqType}};

    if ($keyConf == $ComKeyConf::RemoconKeyCode->{keyMenu}) {
        openlog('aile-web', 'pid', 'local0');
        syslog('info', "Web Menu(F1) Key Pushed.");
        closelog();
    }

    my $keyCode = $keyConf->[0];
    for (my $i = 0; $i < @$keyCode; $i++) {
        $exec_cmd = sprintf(ComKeyConf::KEYPUSH_CMD, $keyCode->[$i], $keyCode->[$i]);
        system($exec_cmd);
        if ($firstFlg) {
            $firstFlg = 0;
            usleep(550000);
        } else {
            usleep(100000);
        }
    }
}

1;
