/* --- [初期定義] -------------------------------------------------- */
var validate = {config:{}};
validate.resultObj = {state:true, msg:[]};
validate.configJson = "js/json/validate.json";
validate.kbnJson = "js/json/kbn.json";
validate.messageJson = "js/json/message.json";
validate.kbnObj = {};
validate.messageObj = {};
validate.messageArray = new Array();

// 各単項目チェックエラー時のエラーメッセージコード
validate.functionMsgConfig = {
    required:            "MSG001",
    len:                 "MSG002",
    haneisukigo:         "MSG003",
    haneisukigoP:        "MSG003",
    num:                 "MSG004",
    kbn:                 "MSG005",
    range:               "MSG006",
    format:              "MSG005",
    isAssignedName:      "MSG019",
    isIpFormat:          "MSG007",
    isNtpServer:         "MSG008",
    isEqual:             "MSG009",
    isNotEqual:          "MSG010",
    isChanged:           "MSG011",
    kbnMulti:            "MSG012",
    forbbidden:          "MSG013",
    hankaku:             "MSG014",
    hostFormat:          "MSG015",
    ugFormat:            "MSG016",
    forbbiddenInput:     "MSG017",
    forbbiddenInputSF:   "MSG020",
    forbbiddenInputPlus: "MSG018",
    zeroOver:            "MSG021",
    isNumericAlpha:      "MSG022",
};

/* ---------------------------------------------------------------- */
/* --- [チェック関数] -------------------------------------------------- */
// 数値チェック
validate.isNum = function(value, args) {
    if (value.match(/[^0-9]+/) ){
        return false;
    }
    return true;

}

// 半角英数チェック
validate.isNumericAlpha = function(value, args) {
    if (!value.match(/^[a-zA-Z0-9]+$/) ){
        return false;
    }
    return true;
}

// 文字列長チェック
validate.lengthValidator = function(value, args) {
    if (value.length > args ){
        return false;
    }
    return true;
}

// 半角英数記号チェック
validate.isHaneisukigo = function(value, args) {
    var symbol = "";
    // 正規表現でエスケープが必要な文字に"\"を付加する
    for(var idx = 0; idx < args.length; idx++){
        var word = args.substr(idx, 1);
        if(word == "\\" || word == "*" || word == "+" || word == "." ||
           word == "?"  || word == "{" || word == "}" || word == "(" ||
           word == ")"  || word == "[" || word == "]" || word == "^" ||
           word == "$"  || word == "-" || word == "|" || word == "/"
        ){
            symbol += "\\" + word;
        }else{
            symbol += word;
        }
    }
    var pattern = "0-9a-zA-Z" + symbol;
    var re = new RegExp("[^" + pattern + "]");
    if (value.match(re) ){
        return false;
    }
    return true;
}

validate.isHaneisukigoPasswd = function(value, args) {
    var pattern = "^[0-9a-zA-Z@`\{\[\]]+$";
    var re = new RegExp(pattern);
    if (value.match(/^[0-9a-zA-Z@`\{\[\]\}\_:\*;\+>\/\?\.,<!#\$%\(\)~\|']+$/) == null){
        return false;
    }
    return true;
}

// 区分値チェック
validate.isKbn = function(value, args) {
    if ($.inArray(value, validate.kbnObj[args]) < 0 ) {
        return false;
    }
    return true;
}

// 範囲チェック
validate.isRange = function(value, args) {
    if (value.length < args[0] || value.length > args[1] ) {
        return false;
    }
    return true;
}

// フォーマットチェック
validate.isFormat = function(value, args) {
    var re = new RegExp(args);
    if (value.match(re) == null){
        return false;
    }
    return true;
}

// 所属名フォーマットチェック
validate.isAssignedName = function(value, args) {
    if (value.match(/^[0-9a-zA-Z!#\$%&\'()\-\.\/@\[\]\^_`\{\}~]+$/) == null){
        return false;
    }
    return true;
}

validate.isIpFormat = function(value, args) {
    if(value.match(/^(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])$/) == null){
        return false;
    }
    return true;
}

validate.isNtpServer = function(value, args) {
    if(value.match(/^([0-9a-zA-Z]+\.)+[a-zA-Z]+$|^([0-9a-zA-Z][0-9a-zA-Z\-]{1,61}[0-9a-zA-Z]\.)+[a-zA-Z.]+$/) == null){
        if(!validate.isIpFormat(value)){
            return false;
        }
    }
    return true;
}

validate.isEqual = function(value, args){
    var values = value.split(" = ");
    if(values[0] != values[1]){
        return false;
    }
    return true;
}

validate.isNotEqual = function(value, args){
    var values = value.split(" = ");
    if(values[0] == values[1]){
        return false;
    }
    return true;
}

validate.isChanged = function(value, args){
    var values = value.split(" = ");
    if(values[0] == values[1]){
        return false;
    }
    return true;
}

validate.kbnMulti = function(value, args){
    var rc = true;
    var values = value.split(",");
    for(idx = 0; idx < values.length; idx++){
        if ($.inArray(values[idx], validate.kbnObj[args]) < 0 ) {
            rc = false;
            break;
        }
    }
    return rc;
}

validate.isForbbidden = function(value, args){
    var rc = true;
    for(idx = 0; idx < args.length; idx++){
        var pattern = '^' + args[idx] + '$';
        var re = new RegExp(pattern, 'i');
        if(value.match(re)){
            return rc = false;
            break;
        }
    }
    return rc;
}

validate.isHankaku = function(value, args){
    var rc = true;
    for(var idx = 0; idx < value.length; idx++){
        var chara = value.charAt(idx);
        var ccode = chara.charCodeAt(0);
        if((ccode >= 0x0 && ccode < 0x81) || (ccode == 0xf8f0) ||
           (ccode >= 0xff61 && ccode < 0xffa0) || (ccode >= 0xf8f1 && ccode < 0xf8f4)){
            rc = true;
        }else{
            rc = false;
            break;
        }
    }
    return rc;
}

validate.isForbbiddenInput = function(value, args){
    if(value.match(/"|\\/)){
        return false;
    }
    return true;
}

validate.isForbbiddenInputSF = function(value, args){
    if(value.match(/"|\\|\//)){
        return false;
    }
    return true;
}

validate.isForbbiddenInputPlus = function(value, args){
    if(value.match(/"|&|=|\\/)){
        return false;
    }
    return true;
}

validate.isHostFormat = function(value, args){
    if(!value.match(/^[0-9a-zA-Z]+$|^[0-9a-zA-Z][0-9a-zA-Z-]+[0-9a-zA-Z]$/)){
        return false;
    }
    return true;
}

validate.isUGFormat = function(value, args){
    if(!value.match(/^[a-zA-Z][0-9a-zA-Z_.-]*[0-9a-zA-Z_.-]?$/)){
        return false;
    }
    return true;
}

validate.isZeroOver = function(value, args){
    if(value <= 0){
        return false;
    }
    return true;
}

// 単項目チェックの関数定義
validate.memberValidateConfig = {
    num:                 validate.isNum,
    haneisukigo:         validate.isHaneisukigo,
    haneisukigoP:        validate.isHaneisukigoPasswd,
    len:                 validate.lengthValidator,
    kbn:                 validate.isKbn,
    range:               validate.isRange,
    format:              validate.isFormat,
    isAssignedName:      validate.isAssignedName,
    isIpFormat:          validate.isIpFormat,
    isNtpServer:         validate.isNtpServer,
    isEqual:             validate.isEqual,
    isNotEqual:          validate.isNotEqual,
    isChanged:           validate.isChanged,
    kbnMulti:            validate.kbnMulti,
    forbbidden:          validate.isForbbidden,
    hankaku:             validate.isHankaku,
    hostFormat:          validate.isHostFormat,
    ugFormat:            validate.isUGFormat,
    forbbiddenInput:     validate.isForbbiddenInput,
    forbbiddenInputSF:   validate.isForbbiddenInputSF,
    forbbiddenInputPlus: validate.isForbbiddenInputPlus,
    zeroOver:            validate.isZeroOver
};


/* -------------------------------------------------------------------- */

/* --- [メイン処理] -------------------------------------------------- */

// 初期処理
validate.validatorExec = function(dataArray) {
    // 各種初期化
    validate.resultObj = {state:true, msg:[]};
    validate.messageObj = {};
    validate.messageArray = new Array();
    // 設定ファイル読込
    $.extend(validate.config ,validate.getJsonFile(validate.configJson));
    $.extend(validate.kbnObj ,validate.getJsonFile(validate.kbnJson));
    $.extend(validate.messageObj ,validate.getJsonFile(validate.messageJson));
    
    // 全項目チェック処理実行
    validate.allCheckFunction(dataArray);
    validate.resultObj.msg = validate.messageArray;
    
    // 処理結果を返す
    return validate.resultObj;
}

// 全項目チェック処理
// 引数は配列（JSONに格納する配列）
validate.allCheckFunction = function(dataArray) {
    // 配列分ループ
    for(key in dataArray) {
        // データ構造判定
        if (jQuery.isArray(dataArray[key]) || jQuery.isPlainObject(dataArray[key])) {
            // value値が配列またはオブジェクトの場合
            validate.allCheckFunction(dataArray[key]);
        } else if(key != "") {
            // 単項目チェック処理実行
            validate.singleCheckFunction(key,dataArray[key]);
        } else {}
    }
}


// 単項目チェック処理
validate.singleCheckFunction = function( key,value ) {
   var errorMessage = "";
   var msgCd = "";
   
   // チェック項目取得
   var validateKbn = this.config[key].validate;
   
   // 日本語名称取得
   var errorName = this.config[key].errname;
   
   // 必須チェック
   if(this.config[key].required) {
       if(value == "") {
           // チェック結果更新
           validate.resultObj.state = false;
               
           // エラーメッセージを取得
           var messageArgs = errorName;
           msgCd = this.functionMsgConfig['required'];
           errorMessage = validate.getMessage(msgCd, messageArgs);
           validate.messageArray.push(errorMessage);
           return;
       }
   }

   // チェック項目分ループ
   var validateKbnArray = validateKbn.split(",");
   for(var i =0; i < validateKbnArray.length; i++) {
       // チェック関数判定
       var funcExpr = validateKbnArray[i].trim();

       if(typeof this.config[key][funcExpr] === "undefined"){
           var funcName = funcExpr;
           var args = "";
       }else{
           var funcName = funcExpr;
           var args = this.config[key][funcExpr];
           for(idx in args){
               args[idx] = args[idx].trim();
           }
       }

       // チェック関数取得
       var targetFunc = validate.memberValidateConfig[funcName];
   
       // チェック関数実行
       if(targetFunc) {
           if (!targetFunc(value, args)) {
               // チェック結果更新
               validate.resultObj.state = false;
               
               // エラーメッセージを取得
               msgCd = this.functionMsgConfig[funcName];
               var messageArgs;
               if(args instanceof Array){
                   messageArgs = new Array(errorName).concat(args);
               }else{
                   messageArgs = new Array(errorName,args);
               }
               errorMessage = validate.getMessage(msgCd, messageArgs);
               validate.messageArray.push(errorMessage);
           }
       }
   }
}


/* ------------------------------------------------------------------- */
/* --- [共通メソッド] -------------------------------------------------- */
// 設定ファイル(JSON)を取得して返す
validate.getJsonFile = function( url) {
    var obj;
    $.ajax( {
        url: url,
        dataType : 'json',
        async: false,
        success: function( json ) {
            obj = json;
        },
        error: function( json ) {
            obj =  json;
        }
    });
    
    return obj;
    
}

// メッセージ設定
validate.getMessage = function(msgCd, args) {
    var message = validate.messageObj[msgCd];
    
    if(!message) {
        return "メッセージが未定義です[" + msgCd + "]";
    }
    
    // メッセージ置換
    if(args instanceof Array) {
        for(var i=0; i < args.length; i++) {
            args[i] = args[i].replace(">", "&lt;");
            args[i] = args[i].replace("<", "&gt;");
            message = message.replace("{" + i + "}", args[i]);
        }
        return message;
    } else if(typeof args == "string") {
        return message.split("{0}").join(args);
    } else {
      return message;
    }
}

