var ProductNo = "";
var CameraNum = 0;
var SpecialConf = "";
var menuItems = new Array();
var btnConfValue = new Array();
var deviceType = "pc";
var menuTemp = {};
var sliderOption = {}
var normalBtnSign     = "N";
var continuousBtnSign = "C";
var menuTypeNoLink = "-";
var menuTypeLink   = "A";
var cmdTypeOfSystem = "S";
var cmdTypeOfAileun = "A";
var remoconWindowWidth=920;

var tmplMenuLink    = '<a href="#" onClick="viewSwitch(\'$ID\', \'link\')">$MENU</a>';
var tmplMenuNoLink = '$MENU';

/* touchできる環境下判別 */
var isTouch = ('ontouchstart' in window);
var isOnButtonDown = false;
var isExecutingCmd = false;
var mouseDownIntervalId = null;

var curPage = 0;
var pageRows = 0;
var pages = 0;

$(function(){
    // エラーダイアログ
    $('#exec_remocon_operate_error').dialog({
        modal: true,
        autoOpen: false,
        resizable: false,
        minWidth: 450,
        open: function(event, ui){
            $('.ui-dialog-titlebar-close').hide();
        },
        buttons: {
            'OK': function(){
                $(this).dialog('close');
            }
        }
    });
});

function prevPageTransion() {
    curPage = curPage - 1;
    if (curPage < 0) {
        curPage = pages;
    }
    switchCameraSelectButtonPage();
}

function nextPageTransion() {
    curPage = (curPage + 1);
    if (curPage > pages) {
        curPage = 0;
    }
    switchCameraSelectButtonPage();
}

function switchCameraSelectButtonPage() {
    var idx, jdx;

    for (idx = 0; idx <= pages; idx++) {
        for (jdx = 0; jdx < pageRows; jdx++) {
            var selectorName = "page" + idx + "_row" + jdx;
            if ($("#"+selectorName).size()) {
                if (idx == curPage) {
                  $("#"+selectorName).css("display", "table-row");
                } else {
                  $("#"+selectorName).css("display", "none");
                }
            }
        }
    }
    $("#page").html((curPage + 1));
}

function getAileProductInfo(){
    var res;
    var cgiUrl = createCgiUrl(location, "getAileProductInfo.pl");
    
    $.ajax({
        async: false,
        type: 'POST',
        url: cgiUrl,
        data: {},
        dataType: 'json',
        complete: function(jqXHR, textStatus){
            if(textStatus == const_timeout){
                $('#timeout_error').dialog('open');
            }
        },
        success: function(res){
            if(res['status'] == 0){
                var prdctInfo = res['data']['ProductInfo'];
                ProductNo = prdctInfo['AileProductNo'];
                CameraNum = prdctInfo['AileCameraNum'];
                SpecialConf = prdctInfo['AileSpecialConfig'];
                getWebRemoteControlerConfig(CameraNum+SpecialConf);
            }
        }
    });
}

function getWebRemoteControlerConfig(productKey){
    var res;
    var cgiUrl = createCgiUrl(location, "getWebRemoteControlerConfig.pl");
    var obj = {"ProductKey":productKey};
    var sendData = JSON.stringify(obj);

    $.ajax({
        async: false,
        type: 'POST',
        url: cgiUrl,
        data: {
            data: sendData
        },
        dataType: 'json',
        complete: function(jqXHR, textStatus){
            if(textStatus == const_timeout){
                $('#timeout_error').dialog('open');
            }
        },
        success: function(res){
            if(res['status'] == 0){
                var WRCConfig = res['data']['WRCConfig'];
                createRemoteControlContents(res['data']['WRCConfig'], sliderOption);
                switchCameraSelectButtonPage();
            }
        }
    });
}

function createRemoteControlContents(WRCConfig, sliderOption) {
    var menuNum = Object.keys(WRCConfig).length;
    var menuWidthRate = Math.floor(100/menuNum);
    var wrcMenuHtml = ""
    var menuKeyHtml = "";
    var menuKeyBarHtml = "";
    var slideBodyHtml = '<div class="flexslider"><ul class="slides">';

    var idx = 1;
    for(var x in WRCConfig){
        for(var y in WRCConfig){
            if(WRCConfig[y]['Order'] == idx){
                menuItems[WRCConfig[y]['Order']] = WRCConfig[y];
                menuKeyHtml += "<td align='center' width='" + menuWidthRate + "%'><h4><div id='menu"+WRCConfig[y]['Order']+"'></div></h4></td>";
                menuKeyBarHtml += "<td id='menu"+WRCConfig[y]['Order']+"_bar' style='border-style:none hidden hidden hidden;' bgcolor='#EBEBEB'></td>";
                slideBodyHtml += "<li><div width='100%'><div id='menu"+WRCConfig[y]['Order']+"_body' style='display:block'></div></div></li>";
                idx++;
                break;
            }
        }
    }
    wrcMenuHtml = "<table width='100%'  border='1'><tr>" + menuKeyHtml + "</tr><tr>" + menuKeyBarHtml + "</tr></table>";
    slideBodyHtml += "</ul></div>";
    $('#wrcMenu').html(wrcMenuHtml);
    $('#menuBody').html(slideBodyHtml);
    for(var x in WRCConfig){
        var root = false;
        var menu = menuTemp['Link'];
        if(WRCConfig[x]['Order'] == "1"){
            root = true;
            menu = menuTemp['NoLink'];
        }
        createMenuKey(WRCConfig[x]['Order'], WRCConfig[x]['ID'], WRCConfig[x]['MenuName'], root, menu);
    }
    $('.flexslider').flexslider(sliderOption);
    for(var x in menuItems){
        createWebRmoteControler(x, menuItems[x]);
    }
}

function createMenuKey(order, menuId, menuName, root, menuTemplate){
    var menuKey = "";
    var keyId = "menu" + order;
    var barId = keyId + "_bar";
    var bodyId = keyId + "_body";
    var barColor = root ? "orange" : "#EBEBEB";
    var dispStyle = root ? "block" : "none";

    if(menuTemplate.type == menuTypeNoLink){
        menuKey = menuTemplate.template.replace("$MENU", menuName);
    }else if(menuTemplate.type == menuTypeLink){
        menuKey = menuTemplate.template.replace("$MENU", menuName).replace("$ID", menuId);
    }else{
        menuKey = "";
    }
    $('#'+keyId).html(menuKey);
    $('#'+barId).css('background-color', barColor);
    $('#'+bodyId).css('display', dispStyle);
}

function createWebRmoteControler(order, rcObjects){
    var wrcBody = "";
    var wrcBodyId = "menu"+order+"_body";

    if(rcObjects['Type'] === "Normal"){
        wrcBody = createWebControlerButton(rcObjects);
    }else if(rcObjects['Type'] === "Selector"){
        wrcBody = createWebControlerSelector(rcObjects);
    }else{
        wrcBody =  "";
    }

    $('#'+wrcBodyId).html(wrcBody);
    setEvent4ContinuousButtonObjcts(rcObjects);
}

function createWebControlerButton(rcObjects){
    var wrcHtml = "";
    var colNum = rcObjects['ColNum'];
    var ctrlItem = rcObjects['Items'];
    var widthRate = Math.floor(100/colNum);
    var rowKeys = getItemKeys(rcObjects['Items']);
	var pagingHtml = "";
    var rowCount = 0;
    var pageCount = 0;

    if (deviceType == "pc") {
        pagingHtml = "<tr><td><button id=\"prev\" onClick=\"prevPageTransion();\"><span><h4>前ページ</h4></span></button></td><td align=\"center\"><h4><span id=\"page\"></span>ページ</h4></td><td align=\"right\"><button id=\"next\" onClick=\"nextPageTransion();\"><span><h4>次ページ</h4></span></button></td></tr>";
    } else {
       var pagingHtml = "<tr><td><button id=\"prev\" onClick=\"prevPageTransion();\"><span>前ページ</span></button></td><td align=\"center\"><span id=\"page\"></span>ページ</td><td align=\"right\"><button id=\"next\" onClick=\"nextPageTransion();\"><span>次ページ</span></button></td></tr>";
    }

    wrcHtml =  "<div>";
    wrcHtml += "<table width='100%'>";
    for(var itemIndex = 0; itemIndex < rowKeys.length; itemIndex++){
        var rowItems = rcObjects['Items'][rowKeys[itemIndex]];
        if (rcObjects['Paging'] == "ON" && itemIndex > rcObjects['IgnoreRows']) {
            if (rowCount == rcObjects['PageRows']) {
                rowCount = 0;
                pageCount++;
            }
            wrcHtml += "<tr id=\"page" + pageCount + "_row" + rowCount + "\">";
            rowCount++;
        } else {
            wrcHtml += "<tr>";
        }
        for(var idx in rowItems){
            var btnConf = rowItems[idx];
            var btnItem = btnConf['item'];
            var btnType = btnConf['btnType'];
            var btnId = btnConf['id'];
            var cmdType = btnConf['cmdType'];
            btnConfValue[btnId] = btnConf;
            wrcHtml += "<td align='center' width='" + widthRate + "%'>";
            if(btnItem !== ""){
                if(btnType == normalBtnSign){
                    wrcHtml += "<button id='"+btnId+"' type='button' class='radiusButtonFull radiusButtonFullFont' onClick=\"wrcClickOne('"+btnId+"')\">"+btnItem+"</button>";
                }else if(btnType == continuousBtnSign){
                    wrcHtml += "<button id='"+btnId+"' type='button' class='radiusButtonFull radiusButtonFullFont'>"+btnItem+"</button>";
                }else{
                    wrcHtml += "<button id='"+btnId+"' type='button' class='radiusButtonFull radiusButtonFullFont'>"+btnItem+"</button>";
                }
            }
            wrcHtml += "</td>";
        }
        wrcHtml += "</tr>";
    }

    if (rcObjects['Paging'] == "ON") {
        wrcHtml += pagingHtml;
        pages = pageCount;
        pageRows = rcObjects['PageRows'];
    }

    wrcHtml += "</table>";
    wrcHtml += "</div>";

    return wrcHtml;
}

function getItemKeys(obj)
{
    var keys = new Array();
    for(var no in obj){
        keys.push(parseInt(no, 10));
    }
    keys.sort(function(a,b){
        if(a < b) return -1;
        if(a > b) return 1;
        return 0;
    });

    return keys;
}

function createWebControlerSelector(rcObjects){
    var wrcHtml = "";
    var colNum = rcObjects['ColNum'];
    var ctrlItem = rcObjects['Items'];
    var widthRate = Math.floor(100/colNum);
    var rowKeys = getItemKeys(rcObjects['Items']);

    wrcHtml =  "<div>";
    wrcHtml += "<table width='100%' border='1'><tr><td>";
    for(var itemIndex = 0; itemIndex < rowKeys.length; itemIndex++){
        var rowItems = rcObjects['Items'][rowKeys[itemIndex]];
        var name = rowItems['Name'];
        var type = rowItems['Type'];

        wrcHtml += "<table width='100%'>";
        if(type === 'TEXT'){
            if(name !== ""){
                wrcHtml += "<tr><td><hr><div width='100%' style='margin: 1px 1px 1px 15px'><h4><B>"+name+"</B></h4></div><hr></td></tr>";
            }else{
                wrcHtml += "<tr><td><div width='100%' style='margin: 1px 1px 1px 15px'><h4><B>"+name+"</B></h4></div></td></tr>";
            }
        }else if(type === 'BUTTON'){
            wrcHtml += "<tr><td><hr><div width='100%' style='margin: 1px 1px 1px 15px' align='center'><h4><p class='buttonLink' style='width:15%'><a href='#'>"+name+"</a></p></h4></div></td></tr>";
        }else{
            wrcHtml += "<tr><td><div width='100%' style='margin: 1px 1px 1px 15px'></div></td></tr>";
        }
        var confItems = rowItems['ConfigItems'];

         for(var item in confItems){
             var selectItems = confItems[item]['SelectItems'];
             wrcHtml += "<tr><td><div width='100%' style='margin: 1px 1px 1px 30px'>";
             wrcHtml += "<span class='span2'><B>"+confItems[item]['ConfigName']+"</B></span>";
             wrcHtml += "<span class='span10'>";
             wrcHtml += "<select>";
             for(var selItem in selectItems){
                 wrcHtml += "<option value='"+selItem+"'>"+selectItems[selItem]+"</option>";
             }
             wrcHtml += "</select>";
             wrcHtml += "</span>";
             wrcHtml += "</div></td></tr>";
         }
         wrcHtml += "</table>";
    }
    wrcHtml += "</td></tr></table>";
    wrcHtml += "</div>";

    return wrcHtml;
}

function viewSwitch(id, type) {
    for(var x in menuItems){
        var root = false;
        var menu = menuTemp['Link'];
        if(menuItems[x]['ID'] === id){
            if(type != ""){
                $('.flexslider').flexslider(x-1);
            }
            root = true;
            var menu = menuTemp['NoLink'];
        }
        createMenuKey(menuItems[x]['Order'], menuItems[x]['ID'], menuItems[x]['MenuName'], root, menu);
    }
}

function setEvent4ContinuousButtonObjcts(rcObjects){
    for(var rowNo in rcObjects['Items']){
        var rowItems = rcObjects['Items'][rowNo];
        for(var idx in rowItems){
            var btnConf = rowItems[idx];
            var btnType = btnConf['btnType'];
            var btnId = btnConf['id'];
            if(btnType == continuousBtnSign){
                var obj = document.getElementById(btnId);
                // PCとスマホ/タブレットでイベントが異なるので分ける
                if(deviceType == "pc"){
                    // pc版はマウスイベントで処理
                    // Touchイベントが使えたとしてもタッチイベントは登録しない
                    obj.onmousedown = function(e){
                        if(!e) e = window.event;
                        e.preventDefault();
                        var id = "";
                        if(e.srcElement){
                            // Chrome, IE
                            id = e.srcElement.id;
                        }else{
                            // FireFox
                            id = e.target.id;
                        }
                        var buttons = MouseEventGetChangedButtons(e);
                        if(buttons & 0x0001) {
                            isOnButtonDown = true;
                            if(mouseDownIntervalId == null && isOnButtonDown){
                                mouseDownIntervalId = setInterval(
                                    function(){
                                        if(isOnButtonDown){
                                            btnClickEventAction(id);
                                        }
                                    }, 1000
                                );
                            }
                            btnClickEventAction(id);
                        }
                    }
                    obj.onmouseup = function(e){
                        if(!e) e = window.event;
                        e.preventDefault();
                        var buttons = MouseEventGetChangedButtons(e);
                        if(buttons & 0x0001){
                            clearInterval(mouseDownIntervalId);
                            isOnButtonDown = false;
                            mouseDownIntervalId = null;
                        }
                    }
                    obj.onmouseout = function(e){
                        if(!e) e = window.event;
                        e.preventDefault();
                        clearInterval(mouseDownIntervalId);
                        isOnButtonDown = false;
                        mouseDownIntervalId = null;
                    }
                }else{
                    // スマホ/タブレット版はタッチイベントで処理
                    var isEventListener = obj.addEventListener ? true : false;
                    if(isTouch && isEventListener){
                        /* touch開始イベント登録 */
                        obj.addEventListener(
                            'touchstart',
                            function(e){
                                e.preventDefault();
                                var id = e.currentTarget.id;

                                isOnButtonDown = true;
                                if(mouseDownIntervalId == null && isOnButtonDown){
                                    mouseDownIntervalId = setInterval(
                                        function(){
                                            if(isOnButtonDown){
                                                btnClickEventAction(id);
                                            }
                                        }, 1000
                                    );
                                }
                                btnClickEventAction(id);
                            },
                            false
                        );
                        /* touch終了イベント */
                        obj.addEventListener(
                            'touchend',
                            function(e){
                                e.preventDefault();
                                clearInterval(mouseDownIntervalId);
                                isOnButtonDown = false;
                                mouseDownIntervalId = null;
                            },
                            false
                        );
                        /* touchキャンセルイベント */
                        obj.addEventListener(
                            'touchcancel',
                            function(e){
                                e.preventDefault();
                                clearInterval(mouseDownIntervalId);
                                isOnButtonDown = false;
                                mouseDownIntervalId = null;
                            },
                            false
                        );
                    }
                }
            }
        }
    }
}

function MouseEventGetChangedButtons(event_obj){
    try{
        if(event_obj instanceof MouseEvent){
            var buttons = 0;
            if(event_obj.button == 0) buttons |= 0x01;
            if(event_obj.button == 1) buttons |= 0x04;
            if(event_obj.button == 2) buttons |= 0x02;
            return buttons;
        }
    }catch(e){
    }
    return event_obj.button;
}

function wrcClickOne(id){
    btnClickEventAction(id);
}

function btnClickEventAction(id){
    /* 実行中は動作しない */
    if(isExecutingCmd){
        return;
    }

    var cgiUrl = createCgiUrl(location, "AileHttpCtrlCom.pl");
    var type = btnConfValue[id]['cmdType'];
    var obj = "type="+type+"&sendkey="+btnConfValue[id]['reqType'];
    if(btnConfValue[id]['value'] != ""){
        obj += "&value="+btnConfValue[id]['value'];
    }

    isExecutingCmd = true;
    $.ajax({
        async: true,
        type: 'GET',
        url: cgiUrl,
        data: obj,
        complete: function(jqXHR, textStatus){
            isExecutingCmd = false;
            if(textStatus == const_timeout){
                $('#timeout_error').dialog('open');
            }
        },
        success: function(res){
            var resArrayStrings = res.split("&");
            var tmp1stRes = resArrayStrings[0].split("=");
            var tmp2ndRes = resArrayStrings[1].split("=");
            var status;
            var message;
            if ("status" == tmp1stRes[0]) {
                status = tmp1stRes;
                message = tmp2ndRes;
            } else {
                status = tmp2ndRes;
                message = tmp1stRes;
            }
            if(status[1] != 0){
                var showMessage = "";
                if(message[1] != ""){
                    var messages = message[1].split(".");
                    messages.pop();
                    showMessage = messages.join("<br>");
                }else{
                    if(type == cmdTypeOfAileun){
                        showMessage = i18n.t("InterProcComError.AILE-NO-STARTING");
                    }else{
                        showMessage = i18n.t("SystemOpeError.INTERNAL-SERVER-ERROR");
                    }
                }
                $('#remocon_operate_error_message').html(showMessage);
                $('#exec_remocon_operate_error').dialog('open');
            }
        }
    });
}
