$(function(){
    $.ajaxSetup({cache: false, asysnc: true, timeout: 90000});
    alterWidth4RadiusButton();

    // ファイル選択エラーダイアログ
    $('#file_select_err').dialog({
        modal: true,
        autoOpen: false,
        resizable: false,
        open: function(event, ui){
            $('.ui-dialog-titlebar-close').hide();
        },
        buttons: {
            'OK': function() {
                $(this).dialog('close');
            }
        }
    });

    // ファイル転送エラーダイアログ
    $('#file_transfer_err').dialog({
        modal: true,
        autoOpen: false,
        minWidth: 480,
        resizable: false,
        open: function(event, ui){
            $('.ui-dialog-titlebar-close').hide();
        },
        buttons: {
            'OK': function() {
                $(this).dialog('close');
            }
        }
    });

    // アラーム音工場初期化実行確認ダイアログ
    $('#confirm_init_alarm_sound').dialog({
        modal: true,
        autoOpen: false,
        minWidth: 340,
        resizable: false,
        open: function(event, ui){
            $('.ui-dialog-titlebar-close').hide();
        },
        buttons: {
            'OK': function(){
                // アラーム音工場初期化
                initAlarmSoundFile();
                $(this).dialog('close');
            },
            'Cancel': function(){
                $(this).dialog('close');
            }
        }
    });

    // アラーム音アップロード実行完了ダイアログ
    $('#during_init_alarm_sound').dialog({
        modal: true,
        autoOpen: false,
        open: function(event, ui){
            $('.ui-dialog-titlebar-close').hide();
        },
        buttons: {
            'OK': function(){
                $(this).dialog('close');
            }
        }
    });

    // アラーム音アップロード実行確認ダイアログ
    $('#confirm_upload_alarm_sound').dialog({
        modal: true,
        autoOpen: false,
        minWidth: 400,
        resizable: false,
        open: function(event, ui){
            $('.ui-dialog-titlebar-close').hide();
        },
        buttons: {
            'OK': function(){
                // 設定ファイルの転送
                transferAlarmSoundFile();
                $(this).dialog('close');
                
            },
            'Cancel': function(){
                $(this).dialog('close');
            }
        }
    });

    // アラーム音アップロード実行完了ダイアログ
    $('#during_upload_alarm_sound').dialog({
        modal: true,
        autoOpen: false,
        open: function(event, ui){
            $('.ui-dialog-titlebar-close').hide();
        },
        buttons: {
            'OK': function(){
                $(this).dialog('close');
            }
        }
    });

    // 実行中ダイアログ
    $('#executing_process').dialog({
        modal: true,
        autoOpen: false,
        open: function(event, ui){
            $('.ui-dialog-titlebar-close').hide();
        }
    });

    // アラーム音工場初期化実行ボタンクリック時の処理
    $('#btn_init_alarm_sound_execute').click(function(){
        // Basic認証がOKの場合ダイアログ表示
        if(doBasicAuthorize()){
            if(!isWebFuncLimited()){
                $('#confirm_init_alarm_sound').dialog('open');
            }
        }
    });

    // アラーム音アップロード実行ボタンクリック時の処理
    $('#btn_upload_alarm_sound_execute').click(function(){
        var file = $('#file-input1').prop('files')[0];
        if(file != null){
            // Basic認証がOKの場合ダイアログ表示
            if(doBasicAuthorize()){
                if(!isWebFuncLimited()){
                    $('#confirm_upload_alarm_sound').dialog('open');
                }
            }
        }else{
            $('#file_select_err').dialog('open');
        }
    });

    $(function(){
        var ua = window.navigator.userAgent.toLowerCase();
        if(ua.indexOf('safari') != -1){
            $('#file-input1').css('width', '0px');
            $('#file-input1').css('height', '0px');
            $('#file-input1').css('display', '0px');
        }
    });

    $('#file-selector1').click(function(){
        $('#file-input1').click();
    });

    $('#file-input1').change(function(){
        $('#selected-file1').html($(this).val());
    });

    $('#file-deletor1').click(function(){
        $('#file-input1').val("");
        $('#selected-file1').html("select file...");
    });
});

function initAlarmSoundFile(){
    var cgiUrl = "";
    var res;
    cgiUrl = createCgiUrl(location, "interProcessCom.pl");
    var res;
    var obj = {
        btnId: "btnExecInitAlarmSound",
        reqType: "ALARM_SOUND_INIT",
        targetView: -999
    };
    var sendData = JSON.stringify(obj);

    $.ajax({
        type: 'POST',
        url: cgiUrl,
        data: {
            data: sendData
        },
        dataType: 'json',
        complete: function(jqXHR, textStatus){
            if(textStatus == const_timeout){
                $('#timeout_error').dialog('open');
            }
        },
        success: function(res) {
            $('#during_init_alarm_sound').dialog('open');
        }
    });
}

// AlaramSoundファイル転送
function transferAlarmSoundFile() {
    var cgiUrl = createCgiUrl(location, "uploadAlarmSoundFile.pl");
    var file = $('#file-input1').prop('files')[0];
    var res;
    
    var fd = new FormData();
    fd.append("sound-file", file);
    var postData = {
        type: 'POST',
        dataType: 'text',
        data: fd,
        processData: false,
        contentType: false
    };
    
    $('#executing_process').dialog('open');
    $('#executing_process_message').html('ファイル転送中....' + loading_img);

    var jqxhr = $.ajax(cgiUrl, postData).done(function(res){
        var tmp = JSON.parse(res);
        if(tmp['status'] != 0){
            // ファイル転送エラー
            $('#file_transfer_err').dialog('open');
            $("#file_transfer_err_msg").html(tmp['message']);
        } else {
            // アプリへアラーム音ファイルの変更通知
            execute_notify_alarm_sound_change();
        }
    });
    
    jqxhr.always(function(){
        $('#executing_process').dialog('close');
        $('#executing_process_message').html("");
        if(jqxhr.statusText == const_timeout){
            $('#timeout_error').dialog('open');
        }
    });
}

// アプリへアラーム音ファイルの変更通知
function execute_notify_alarm_sound_change() {
    var cgiUrl = "";
    var res;
    cgiUrl = createCgiUrl(location, "interProcessCom.pl");
    var res;
    var obj = {
        btnId: "btnExecUpdAlarmSound",
        reqType: "ALARM_SOUND_CUSTOM",
        targetView: -999
    };
    var sendData = JSON.stringify(obj);

    $.ajax({
        type: 'POST',
        url: cgiUrl,
        data: {
            data: sendData
        },
        dataType: 'json',
        complete: function(jqXHR, textStatus){
            if(textStatus == const_timeout){
                $('#timeout_error').dialog('open');
            }
        },
        success: function(res) {
            $('#during_upload_alarm_sound').dialog('open');
        }
    });
}
