$(function(){
    $.ajaxSetup({cache: false, asysnc: true, timeout: 90000});
    alterWidth4RadiusButton();

    // ファイル選択エラーダイアログ
    $('#file_select_err').dialog({
        modal: true,
        autoOpen: false,
        resizable: false,
        open: function(event, ui){
            $('.ui-dialog-titlebar-close').hide();
        },
        buttons: {
            'OK': function() {
                $(this).dialog('close');
            }
        }
    });

    // ファイル転送エラーダイアログ
    $('#file_transfer_err').dialog({
        modal: true,
        autoOpen: false,
        minWidth: 480,
        resizable: false,
        open: function(event, ui){
            $('.ui-dialog-titlebar-close').hide();
        },
        buttons: {
            'OK': function() {
                $(this).dialog('close');
            }
        }
    });

    // 設定セーブ実行確認ダイアログ
    $('#confirm_dl_config').dialog({
        modal: true,
        autoOpen: false,
        minWidth: 340,
        resizable: false,
        open: function(event, ui){
            $('.ui-dialog-titlebar-close').hide();
        },
        buttons: {
            'OK': function(){
                // 設定ファイルの取得
                dlAileunConfigFiles();
                $(this).dialog('close');
            },
            'Cancel': function(){
                $(this).dialog('close');
            }
        }
    });

    // 設定ロード実行確認ダイアログ
    $('#confirm_setting_load').dialog({
        modal: true,
        autoOpen: false,
        minWidth: 400,
        resizable: false,
        open: function(event, ui){
            $('.ui-dialog-titlebar-close').hide();
        },
        buttons: {
            'OK': function(){
                // 設定ファイルの転送
                transferSettingsFile();
                $(this).dialog('close');
                
            },
            'Cancel': function(){
                $(this).dialog('close');
            }
        }
    });

    // 設定ロード実行完了ダイアログ
    $('#during_setting_load').dialog({
        modal: true,
        autoOpen: false,
        open: function(event, ui){
            $('.ui-dialog-titlebar-close').hide();
        },
        buttons: {
            'OK': function(){
                $(this).dialog('close');
            }
        }
    });

    // バージョンアップ実行確認ダイアログ
    $('#confirm_update').dialog({
        modal: true,
        autoOpen: false,
        minWidth: 350,
        resizable: false,
        open: function(event, ui){
            $('.ui-dialog-titlebar-close').hide();
        },
        buttons: {
            'OK': function(){
                // 設定ファイルの転送
                transferUpdateFile();
                $(this).dialog('close');
                
            },
            'Cancel': function(){
                $(this).dialog('close');
            }
        }
    });

    // バージョンアップ実行完了ダイアログ
    $('#during_update').dialog({
        modal: true,
        autoOpen: false,
        minWidth: 340,
        resizable: false,
        open: function(event, ui){
            $('.ui-dialog-titlebar-close').hide();
        },
        buttons: {
            'OK': function(){
                $(this).dialog('close');
            }
        }
    });

    // 実行中ダイアログ
    $('#executing_process').dialog({
        modal: true,
        autoOpen: false,
        open: function(event, ui){
            $('.ui-dialog-titlebar-close').hide();
        }
    });

    // 設定ダウンロード実行ボタンクリック時の処理
    $('#btn_save_execute').click(function(){
        // Basic認証がOKの場合ダイアログ表示
        if(doBasicAuthorize()){
            if(!isWebFuncLimited()){
                $('#confirm_dl_config').dialog('open');
            }
        }
    });

    // 設定アップロード実行ボタンクリック時の処理
    $('#btn_load_execute').click(function(){
        var file = $('#file-input1').prop('files')[0];
        if(file != null){
            // Basic認証がOKの場合ダイアログ表示
            if(doBasicAuthorize()){
                if(!isWebFuncLimited()){
                    $('#confirm_setting_load').dialog('open');
                }
            }
        }else{
            $('#file_select_err').dialog('open');
        }
    });

    // バージョンアップ実行ボタンクリック時の処理
    $('#btn_update_execute').click(function(){
        var file = $('#file-input2').prop('files')[0];
        if(file != null){
            // Basic認証がOKの場合ダイアログ表示
            if(doBasicAuthorize()){
                if(!isWebFuncLimited()){
                    $('#confirm_update').dialog('open');
                }
            }
        }else{
            $('#file_select_err').dialog('open');
        }
    });

    $(function(){
        var ua = window.navigator.userAgent.toLowerCase();
        if(ua.indexOf('safari') != -1){
            $('#file-input1').css('width', '0px');
            $('#file-input1').css('height', '0px');
            $('#file-input1').css('display', '0px');
            $('#file-input2').css('width', '0px');
            $('#file-input2').css('height', '0px');
            $('#file-input2').css('display', '0px');
        }
    });

    $('#file-selector1').click(function(){
        $('#file-input1').click();
    });

    $('#file-selector2').click(function(){
        $('#file-input2').click();
    });

    $('#file-input1').change(function(){
        $('#selected-file1').html($(this).val());
    });

    $('#file-input2').change(function(){
        $('#selected-file2').html($(this).val());
    });

    $('#file-deletor1').click(function(){
        $('#file-input1').val("");
        $('#selected-file1').html("select file...");
    });

    $('#file-deletor2').click(function(){
        $('#file-input2').val("");
        $('#selected-file2').html("select file...");
    });

    // Aileun製品情報取得
    getAileProductInfo();
});

function getAileProductInfo(){
    var res;
    var cgiUrl = createCgiUrl(location, "getAileProductInfo.pl");
    
    $.ajax({
        async: false,
        type: 'POST',
        url: cgiUrl,
        data: {},
        dataType: 'json',
        complete: function(jqXHR, textStatus){
            if(textStatus == const_timeout){
                $('#timeout_error').dialog('open');
            }
        },
        success: function(res){
            if(res['status'] == 0){
                var prdctInfo = res['data']['ProductInfo'];
                setSoftwareVersion(prdctInfo['AileFirmVersion']);
            }
        }
    });
}

function dlAileunConfigFiles(){
    var cgiUrl = createCgiUrl(location, "getAileConfigFiles.pl");

    $('#executing_process').dialog('open');
    $('#executing_process_message').html('ファイル転送中....' + loading_img);

    $.ajax({
        type: 'POST',
        url: cgiUrl,
        data: {},
        dataType: 'json',
        complete: function(jqXHR, textStatus){
            if(textStatus == const_timeout){
                $('#timeout_error').dialog('open');
            }
            $('#executing_process').dialog('close');
            $('#executing_process_message').html("");

        },
        success: function(res){
            if(res['status'] != 0){
                // ファイル転送エラー
                $('#file_transfer_err').dialog('open');
                $("#file_transfer_err_msg").html(res['message']);
            }else{
                location.href = res['data']['RedirectUrl'];
            }
        }
    });
}

// 設定ファイル転送
function transferSettingsFile() {
    var cgiUrl = createCgiUrl(location, "loadSystemSettings.pl");
    var file = $('#file-input1').prop('files')[0];
    var res;
    
    var fd = new FormData();
    fd.append("file", file);
    var postData = {
        type: 'POST',
        dataType: 'text',
        data: fd,
        processData: false,
        contentType: false
    };
    
    $('#executing_process').dialog('open');
    $('#executing_process_message').html('ファイル転送中....' + loading_img);

    var jqxhr = $.ajax(cgiUrl, postData).done(function(res){
        var tmp = JSON.parse(res);
        if(tmp['status'] != 0){
            // ファイル転送エラー
            $('#file_transfer_err').dialog('open');
            $("#file_transfer_err_msg").html(tmp['message']);
        }else{
            // システム再起動
            execute_restart('during_setting_load', 'AILEUN_CONF_UP_REBOOT');
        }
    });
    
    jqxhr.always(function(){
        $('#executing_process').dialog('close');
        $('#executing_process_message').html("");
        if(jqxhr.statusText == const_timeout){
            $('#timeout_error').dialog('open');
        }
    });
}

// バージョンアップファイル転送
function transferUpdateFile() {
    var cgiUrl = createCgiUrl(location, "updateSystem.pl");
    var file = $('#file-input2').prop('files')[0];
    var res;
    
    var fd = new FormData();
    fd.append("file", file);
    var postData = {
        type: 'POST',
        dataType: 'text',
        data: fd,
        processData: false,
        contentType: false
    };
    
    $('#executing_process').dialog('open');
    $('#executing_process_message').html('ファイル転送中....' + loading_img);

    var jqxhr = $.ajax(cgiUrl, postData).done(function(res){
        var tmp = JSON.parse(res);
        if(tmp['status'] != 0){
            // ファイル転送エラー
            $('#file_transfer_err').dialog('open');
            $('#file_transfer_err_msg').html(tmp['message']);
        }else{
            // システム再起動
            execute_restart('during_update', 'AILEUN_APP_REBOOT');
        }
    });
    
    jqxhr.always(function(){
        $('#executing_process').dialog('close');
        $('#executing_process_message').html("");
        if(jqxhr.statusText == const_timeout){
            $('#timeout_error').dialog('open');
        }
    });
}

// システム再起動
function execute_restart(id, reqType) {
    var cgiUrl = "";
    var res;
    cgiUrl = createCgiUrl(location, "interProcessCom.pl");
    var res;
    var obj = {
        btnId: "btnExecReboot",
        reqType: reqType,
        targetView: -999
    };
    var sendData = JSON.stringify(obj);

    $.ajax({
        type: 'POST',
        url: cgiUrl,
        data: {
            data: sendData
        },
        dataType: 'json',
        complete: function(jqXHR, textStatus){
            if(textStatus == const_timeout){
                $('#timeout_error').dialog('open');
            }
        },
        success: function(res) {
            $('#'+id).dialog('open');
        }
    });
}
