$(function(){
    $.ajaxSetup({cache: false, asysnc: true, timeout: 90000});
    alterWidth4RadiusButton();

    // ユーザー／パスワード変更実行確認ダイアログ
    $('#confirm_set_auth_userpass').dialog({
        modal: true,
        autoOpen: false,
        minWidth: 430,
        resizable: false,
        open: function(event, ui){
            $('.ui-dialog-titlebar-close').hide();
        },
        buttons: {
            'OK': function(){
                setAuthUserPasswd();
                $(this).dialog('close');
                
            },
            'Cancel': function(){
                $(this).dialog('close');
            }
        }
    });

    // ユーザー／パスワード変更実行完了ダイアログ
    $('#complete_set_auth_userpass').dialog({
        modal: true,
        autoOpen: false,
        minWidth: 390,
        resizable: false,
        open: function(event, ui){
            $('.ui-dialog-titlebar-close').hide();
        },
        buttons: {
            'OK': function(){
                $(this).dialog('close');
                location.reload();
            }
        }
    });

    // ユーザー／パスワード変更エラーダイアログ
    $('#set_auth_user_input_error').dialog({
        modal: true,
        autoOpen: false,
        resizable: false,
        minWidth: 450,
        open: function(event, ui){
            $('.ui-dialog-titlebar-close').hide();
        },
        buttons: {
            'OK': function(){
                $(this).dialog('close');
            }
        }
    });

    // 実行中ダイアログ
    $('#executing_mod_auth_user_process').dialog({
        modal: true,
        autoOpen: false,
        resizable: false,
        open: function(event, ui){
            $('.ui-dialog-titlebar-close').hide();
        }
    });

    // 変更実行ボタンクリック時の処理
    $('#btn_user_mod_execute').click(function(){
        var username = $('#username').val()
        var password = $('#password').val()
        var password_conf = $('#password_cnf').val()
        var psssword_msk = "";
        for(var idx = 0; idx < password.length; idx++){
            psssword_msk += "*";
        }

        // Basic認証がNGの場合以降の処理をしない
        if(!doBasicAuthorize()){
            return;
        }

        // 機能制限中の場合以降の処理をしない
        if(isWebFuncLimited()){
            return;
        }

        var obj = {
            "userName": username,
            "userPasswd": password
        };
        // 入力チェック
        var chkRes = {};
        chkRes = validate.validatorExec(obj);
        if(chkRes.state == true) {
            var chkObj = {
                "userPasswdEqual": password+" = "+password_conf
            };
            chkRes = validate.validatorExec(chkObj);
        }
        if(chkRes.state == false){
            $('#set_auth_user_error_messages').html(chkRes.msg.join("<br/>"));
            $('#set_auth_user_input_error').dialog('open')
            return false;
        }

        $('#set_auth_user').text($('#username').val());
        $('#set_auth_passwd').text(psssword_msk);

        $('#confirm_set_auth_userpass').dialog('open');
    });
});

function setAuthUserPasswd() {
    var cgiUrl = createCgiUrl(location, "setAuthUserPasswd.pl");
    var userEncStr = Base64.encode($('#username').val() + " " + getKeyStrings(5));
    var passEncStr = Base64.encode($('#password').val() + " " + getKeyStrings(5));
    var passCnfEncStr = Base64.encode($('#password_cnf').val() + " " + getKeyStrings(5));

    var obj = {
        "userName": userEncStr,
        "userPasswd": passEncStr,
        "userPasswdConf": passCnfEncStr
    };

    $('#executing_mod_auth_user_process').dialog('open');
    $('#executing_mod_auth_user_process_message').html('実行中....' + loading_img);
    
    var sendData = JSON.stringify(obj);
    $.ajax({
        type: 'POST',
        url: cgiUrl,
        data: {
            data: sendData
        },
        dataType: 'json',
        complete: function(jqXHR, textStatus){
            $('#executing_mod_auth_user_process').dialog('close');
            $('#executing_mod_auth_user_process_message').html("");
            if(textStatus == const_timeout){
                $('#timeout_error').dialog('open');
            }
        },
        success: function(res){
            if(res['status'] != 0){
                // エラー時の処理
                $('#set_auth_user_error_messages').html(res['message']);
                $('#set_auth_user_input_error').dialog('open');
            }else{
                execAlterBasicAuth();
            }
        }
        
    });
}

function execAlterBasicAuth(){
    var cgiUrl = createCgiUrl(location, "interProcessCom.pl");
    var userEncStr = Base64.encode($('#username').val() + " " + getKeyStrings(5));
    var passEncStr = Base64.encode($('#password').val() + " " + getKeyStrings(5));

    var obj = {
        btnId: "nothing",
        reqType: "ALTER_BASIC_AUTH",
        targetView: -999,
        reqData: "userName#"+userEncStr+"&userPass#"+passEncStr
    };

    var sendData = JSON.stringify(obj);

    $.ajax({
        async: false,
        type: 'POST',
        url: cgiUrl,
        data: {
            data: sendData
        },
        dataType: 'json',
        complete: function(jqXHR, textStatus){
            if(textStatus == const_timeout){
                $('#timeout_error').dialog('open');
            }
        },
        success: function(res){
            if(res['status'] != 0){
                var showMessage = "";
                // エラー時の処理
                if(res['message'] != null && res['message'] != ""){
	                var messages = res['message'].split(".");
                    messages.pop();
    	            showMessage = messages.join("<br>");
                }else{
                    showMessage = i18n.t("InterProcComError.AILE-NO-STARTING");
                }
   	            $('#set_auth_user_error_messages').html(showMessage);
   	            $('#set_auth_user_input_error').dialog('open');
            }else{
                $('#complete_set_auth_userpass').dialog('open');
            }
        }
    });
}
