#!/bin/sh

INSTALL_DIR=/opt
if [ $# -gt 0 -a -d $1 ] ; then
	INSTALL_DIR=$1
fi
AILE_DIR=$INSTALL_DIR/aile
AILE_EXCTRL_DIR=$INSTALL_DIR/aile-exctrl
NGINX_CONF_DIR=/etc/nginx
DEFAULT_DIR=`pwd`

WWW_DIR=/var/www
WWW_SP_DIR=/var/www/sp
AILE_EXCTRL_LOG_DIR=/var/log/aile-exctrl
DEFAULT_BASIC_AUTH_USER=admin
DEFAULT_BASIC_AUTH_PW=11111
BASIC_AUTH_FILE=.htpasswd

### sudoers.d
if [ -e $AILE_EXCTRL_DIR/sudoers.d/aile-exctrl ]; then
	chown root:root $AILE_EXCTRL_DIR/sudoers.d/aile-exctrl
	mv $AILE_EXCTRL_DIR/sudoers.d/aile-exctrl /etc/sudoers.d/aile-exctrl
	chmod 400 /etc/sudoers.d/aile-exctrl
fi

# CGIディレクトリ作成
if [ ! -e $WWW_DIR/cgi-bin ]; then
	mkdir $WWW_DIR/cgi-bin
fi

### nginx
# nginxのパッケージがインストールされている場合
if [ -e $NGINX_CONF_DIR ]; then
	systemctl stop nginx.service
	# defaultのwebサーバー設定を削除
	if [ -e $NGINX_CONF_DIR/sites-enabled/default ]; then
		rm -f $NGINX_CONF_DIR/sites-enabled/default
	fi
	
	# インストーラにnginxの設定が含まれている
	if [ -e $AILE_EXCTRL_DIR/nginx ]; then
		if [ -e $AILE_EXCTRL_DIR/nginx/fcgiwrap ]; then
			systemctl stop fcgiwrap.socket
			systemctl stop fcgiwrap.service
			mv $AILE_EXCTRL_DIR/nginx/fcgiwrap /etc/init.d/fcgiwrap
			systemctl restart fcgiwrap.service
		fi

		# access-auth.conf
		if [ -e $AILE_EXCTRL_DIR/nginx/access-auth.conf ]; then
			mv $AILE_EXCTRL_DIR/nginx/access-auth.conf $AILE_DIR/access-auth.conf
			chown aile:aile $AILE_DIR/access-auth.conf
			chmod 644 $AILE_DIR/access-auth.conf
			if [ ! -e $AILE_DIR/access-authentication.conf ]; then
				cp $AILE_DIR/access-auth.conf $AILE_DIR/access-authentication.conf
			fi
		fi
		# access-no-auth.conf
		if [ -e $AILE_EXCTRL_DIR/nginx/access-no-auth.conf ]; then
			mv $AILE_EXCTRL_DIR/nginx/access-no-auth.conf $AILE_DIR/access-no-auth.conf
			chown aile:aile $AILE_DIR/access-no-auth.conf
			chmod 644 $AILE_DIR/access-no-auth.conf
		fi
		# access-authentication.conf 
		if [ -e $AILE_DIR/access-authentication.conf ]; then
			chown aile:aile $AILE_DIR/access-authentication.conf
			chmod 644 $AILE_DIR/access-authentication.conf
		fi
		if [ -e $AILE_EXCTRL_DIR/nginx/server-name.conf ]; then
			# /opt/aile/にserver-name.confがない場合
			if [ ! -e $AILE_DIR/server-name.conf ]; then
				# server-name.confを作成
				mv $AILE_EXCTRL_DIR/nginx/server-name.conf $AILE_DIR/server-name.conf
				chown aile:aile $AILE_DIR/server-name.conf
				chmod 644 $AILE_DIR/server-name.conf
				# 工場出荷設定用にインストール時のファイルを残しておく
				cp -p $AILE_DIR/server-name.conf $AILE_DIR/server-name.conf.default
			fi
		fi
		# インストーラにlisten-port.confが含まれている場合
		if [ -e $AILE_EXCTRL_DIR/nginx/listen-port.conf ]; then
			# /opt/aileにlisten-port.confがない場合
			if [ ! -e $AILE_DIR/listen-port.conf ]; then
				# インストーラのlisten-port.confをコピー
				mv $AILE_EXCTRL_DIR/nginx/listen-port.conf $AILE_DIR/listen-port.conf
				chown aile:aile $AILE_DIR/listen-port.conf
				chmod 644 $AILE_DIR/listen-port.conf
				# 工場出荷設定用にインストール時のファイルを残しておく
				cp -p $AILE_DIR/listen-port.conf $AILE_DIR/listen-port.conf.default
			fi
		fi
		# aileun-server.conf
		if [ -e $AILE_EXCTRL_DIR/nginx/aileun-server.conf ]; then
			if [ -e $NGINX_CONF_DIR/conf.d/aileun-server.conf ]; then
				cp $NGINX_CONF_DIR/conf.d/aileun-server.conf $NGINX_CONF_DIR/conf.d/aileun-server.conf.org
			fi
			mv $AILE_EXCTRL_DIR/nginx/aileun-server.conf $NGINX_CONF_DIR/conf.d/aileun-server.conf
		fi
		# nginx.conf
		if [ -e $AILE_EXCTRL_DIR/nginx/nginx.conf ]; then
			if [ -e $NGINX_CONF_DIR/nginx.conf ]; then
				mv $NGINX_CONF_DIR/nginx.conf $NGINX_CONF_DIR/_nginx.conf.org
			fi
			mv $AILE_EXCTRL_DIR/nginx/nginx.conf $NGINX_CONF_DIR/nginx.conf
		fi
		# /opt/aile/configにserverName.confがない場合
		if [ ! -e $AILE_DIR/config/serverName.conf ]; then
			# serverName.confを作成
			IP_ADDR=`ifconfig eth0 | grep "inet " | awk '{print $2}' | awk -F: '{print $2}'`
			echo "ServerName=$IP_ADDR" >> $AILE_DIR/config/serverName.conf
			chown aile:aile $AILE_DIR/config/serverName.conf
			chmod 644 $AILE_DIR/config/serverName.conf
			# 工場出荷設定用にインストール時のファイルを残しておく
			cp -p $AILE_DIR/config/serverName.conf $AILE_DIR/serverName.conf.default
		fi
		# インストーラにports.confが含まれている場合
		if [ -e $AILE_EXCTRL_DIR/nginx/ports.conf ]; then
			# /opt/aile/configにports.confがない場合
			if [ ! -e $AILE_DIR/config/ports.conf ]; then
				# インストーラのports.confをコピー
				mv $AILE_EXCTRL_DIR/nginx/ports.conf $AILE_DIR/config/ports.conf
				chown aile:aile $AILE_DIR/config/ports.conf
				chmod 644 $AILE_DIR/config/ports.conf
				# 工場出荷設定用にインストール時のファイルを残しておく
				cp -p $AILE_DIR/config/ports.conf $AILE_DIR/ports.conf.default
			fi
		fi
		# インストーラにwebAccessUser.confが含まれている場合
		if [ -e $AILE_EXCTRL_DIR/nginx/webAccessUser.conf ]; then
			# /opt/aile/configにwebAccessUser.confがない場合
			if [ ! -e $AILE_DIR/config/webAccessUser.conf ]; then
				# インストーラのwebAccessUser.confをコピー
				mv $AILE_EXCTRL_DIR/nginx/webAccessUser.conf $AILE_DIR/config/webAccessUser.conf
				# ユーザaileが変更できるように所有者と権限を変更
				chown aile:aile $AILE_DIR/config/webAccessUser.conf
				chmod 644 $AILE_DIR/config/webAccessUser.conf
			fi
		fi
	fi
	systemctl start nginx.service
	sleep 2
	systemctl restart nginx.service
fi
cd $DEFAULT_DIR;

### ailectrl
chmod 755 $AILE_EXCTRL_DIR/bin
chmod 777 $AILE_EXCTRL_DIR/bin/*
chmod 755 $AILE_EXCTRL_DIR/cgi-bin
chmod 777 $AILE_EXCTRL_DIR/cgi-bin/*
chmod 755 $AILE_EXCTRL_DIR/com-lib
chmod 777 $AILE_EXCTRL_DIR/com-lib/*
chmod 777 $AILE_EXCTRL_DIR/conf
chmod 755 $AILE_EXCTRL_DIR/conf/template
chmod 755 $AILE_EXCTRL_DIR/conf/Locale
chmod 755 $AILE_EXCTRL_DIR/conf/Locale/en
chmod 755 $AILE_EXCTRL_DIR/conf/Locale/ja
chmod 755 $AILE_EXCTRL_DIR/html
chmod 755 $AILE_EXCTRL_DIR/html/css
chmod 755 $AILE_EXCTRL_DIR/html/css/fonts
chmod 755 $AILE_EXCTRL_DIR/html/css/images
chmod 755 $AILE_EXCTRL_DIR/html/fonts
chmod 755 $AILE_EXCTRL_DIR/html/img
chmod 755 $AILE_EXCTRL_DIR/html/js
chmod 755 $AILE_EXCTRL_DIR/html/js/json
chmod 755 $AILE_EXCTRL_DIR/html/locales
chmod 755 $AILE_EXCTRL_DIR/html/locales/dev
chmod 755 $AILE_EXCTRL_DIR/html/locales/en
chmod 755 $AILE_EXCTRL_DIR/html/locales/ja
chmod 755 $AILE_EXCTRL_DIR/html/sp
chmod 777 $AILE_EXCTRL_DIR/data
chmod 777 $AILE_EXCTRL_DIR/tmp

# PC向け
cd $WWW_DIR
if [ -e index.html ]; then
	rm -f index.html
fi
# 検索エンジン/ロボット対策用ファイル
if [ -e $AILE_EXCTRL_DIR/nginx/robots.txt ]; then
	mv $AILE_EXCTRL_DIR/nginx/robots.txt $WWW_DIR/robots.txt
fi
# 認証エラー表示ページ
if [ -e $AILE_EXCTRL_DIR/nginx/error_401.html ]; then
	mv $AILE_EXCTRL_DIR/nginx/error_401.html $WWW_DIR/error_401.html
fi
# NotFoundページ
if [ -e $AILE_EXCTRL_DIR/nginx/error_404.html ]; then
	mv $AILE_EXCTRL_DIR/nginx/error_404.html $WWW_DIR/error_404.html
fi
# webホームディレクトリ
if [ -e $AILE_EXCTRL_DIR/html ]; then
	if [ ! -e aileun_home ]; then
		ln -s $AILE_EXCTRL_DIR/html aileun_home
	fi
fi
# 不要ファイル削除
if [ -e $AILE_EXCTRL_DIR/html/aileun_alarm_sound.html ]; then
	rm -f $AILE_EXCTRL_DIR/html/aileun_alarm_sound.html
fi

cd $WWW_DIR/cgi-bin
if [ -e $AILE_EXCTRL_DIR/cgi-bin ]; then
	if [ ! -e aileun_home ]; then
		ln -s $AILE_EXCTRL_DIR/cgi-bin aileun_home
	fi
fi

# Basic認証のパスワード作成
cd $AILE_EXCTRL_DIR/html
if [ ! -e .htpasswd ]; then
	# デフォルトユーザ
	htpasswd -c -b $BASIC_AUTH_FILE $DEFAULT_BASIC_AUTH_USER $DEFAULT_BASIC_AUTH_PW
	chown aile:aile $BASIC_AUTH_FILE
fi
# データディレクトリ
if [ ! -e data ]; then
	ln -s ../data data
fi
# データディレクトリ
cd locales/dev
if [ ! -e translation.json ]; then
	ln -s ../en/translation.json translation.json
fi
# ログディレクトリ
cd $AILE_EXCTRL_DIR
if [ ! -e log ]; then
	if [ ! -e $AILE_EXCTRL_LOG_DIR ]; then
		mkdir -p $AILE_EXCTRL_LOG_DIR
		chmod 777 $AILE_EXCTRL_LOG_DIR
	fi
	ln -s $AILE_EXCTRL_LOG_DIR $AILE_EXCTRL_DIR/log
fi

# スマホ向け
cd $AILE_EXCTRL_DIR/html/sp
if [ ! -e data ]; then
	ln -s ../data data
fi
if [ ! -e js ]; then
	ln -s ../js js
fi
if [ ! -e css ]; then
	ln -s ../css css
fi
if [ ! -e img ]; then
	ln -s ../img img
fi
if [ ! -e fonts ]; then
	ln -s ../fonts fonts
fi
if [ ! -e locales ]; then
	ln -s ../locales locales
fi
if [ ! -e navibar.html ]; then
	ln -s ../navibar.html navibar.html
fi
if [ ! -e footer.html ]; then
	ln -s ../footer.html footer.html
fi
if [ ! -e S002-01.html ]; then
	ln -s ../S002-01.html S002-01.html
fi
if [ ! -e S003-01.html ]; then
	ln -s ../S003-01.html S003-01.html
fi
if [ ! -e S004-01.html ]; then
	ln -s ../S004-01.html S004-01.html
fi
if [ ! -e S006-01.html ]; then
	ln -s ../S006-01.html S006-01.html
fi

cd $INSTALL_DIR

rm -fr $AILE_EXCTRL_DIR/nginx
rm -fr $AILE_EXCTRL_DIR/sudoers.d
