#!/bin/bash

LOGGER="logger -t StartAile "

ServiceList=("acpid")

if [ $# -ne 1 ]; then
	echo "usage $0 service_name"
	exit -1
fi

service=""
for serviceName in $ServiceList
do
	if [ "$serviceName" = "$1" ]; then
		service=$1
		break;
	fi
done

if [ "$service" = "" ]; then
	echo "invalid service name : [$1]"
	exit -1
fi

for loop in `seq 1 5`
do
	serviceStatus=`systemctl status $service | grep "Active:" | awk '{print $2}'`
	if [ "$serviceStatus" != "active" ]; then
		$LOGGER $service"(call start)"
		sudo systemctl restart $service
	else
		break;
	fi
done

serviceStatus=`systemctl status $service | grep "Active:" | awk '{print $2}'`
if [ "$serviceStatus" != "active" ]; then
	$LOGGER $service"(start failure)"
else
	$LOGGER $service"(started)"
fi

### EOF ###