#!/bin/sh

TIMESTAMP=`date +"%Y%m%d%H%M%S"`
TMP_DIR=/tmp
WORK_DIR=/media/usbflash/$TIMESTAMP/$TIMESTAMP
ZIP_FILE_NAME=${TIMESTAMP}_aileun_support_data.zip
COMPRESS_FILE=/media/usbflash/$ZIP_FILE_NAME

# create working directory

mkdir -p $WORK_DIR/config
mkdir -p $WORK_DIR/log
mkdir -p $WORK_DIR/core

cp /opt/aile/config/* $WORK_DIR/config/
cp /var/log/syslog* $WORK_DIR/log/
cp /var/log/Xorg* $WORK_DIR/log/
cp /opt/aile/version.txt $WORK_DIR/log/
cp /tmp/prdx2wr $WORK_DIR/log/

if [ -e /var/log/nginx ]; then
	cp -a /var/log/nginx $WORK_DIR/log/
fi

CORES=`ls /opt/aile/aile.core.tgz 2>/dev/null | wc -l`
if [ $CORES -ne 0 ]; then
	COMPRESSING=`ps auxw | grep "packcore.sh" | grep -v grep | wc -l`
	if [ $COMPRESSING -eq 0 ]; then
		cp /opt/aile/aile.core.tgz $WORK_DIR/core/
		if [ $? -ne 0 ]; then
			echo "[WARNING] can not copy core files,"
			echo "so don't remove core files in internal storage."
			rm $WORK_DIR/core/aile.core.tgz
			touch $WORK_DIR/core/cannotcopy
		else
			rm /opt/aile/aile.core.tgz
		fi
	else
		touch $WORK_DIR/core/compressing
	fi
fi

# zip圧縮する
cd /media/usbflash/$TIMESTAMP
zip -A -r $COMPRESS_FILE ./* > /dev/null
# モドディレクトリ削除
cd /tmp
rm -fr /media/usbflash/$TIMESTAMP

echo $COMPRESS_FILE

########################
# EOF
########################