#!/bin/bash

ROOT_DIR=/opt/aile
CONFIG_DIR=$ROOT_DIR/config
CONFIG_BAK_DIR=$ROOT_DIR/config_bak

APP_SHUTDOWN_FILE=/tmp/app-aile-shutdown

DONT_REMOVE_FILE_LIST=dont_remove.list

if [ ! -d $CONFIG_BAK_DIR ]; then
	mkdir $CONFIG_BAK_DIR
fi


for confFile in `cat $DONT_REMOVE_FILE_LIST`
do
	if [ -e $CONFIG_DIR/$confFile ]; then
		mv $CONFIG_DIR/$confFile $CONFIG_BAK_DIR/$confFile
	fi
done

rm $CONFIG_DIR/*

mv $CONFIG_BAK_DIR/* $CONFIG_DIR
rm -r $CONFIG_BAK_DIR/

# ない場合は、デフォルトのファイルを作成
$ROOT_DIR/create_gtk_thickness_conf.sh

# nginxのListenポートデフォルトをコピー
if [ -e $ROOT_DIR/listen-port.conf.default ]; then
	cp -f $ROOT_DIR/listen-port.conf.default $ROOT_DIR/listen-port.conf
fi

# nginxのservernameデフォルトをコピー
if [ -e $ROOT_DIR/server-name.conf.default ]; then
	cp -f $ROOT_DIR/server-name.conf.default $ROOT_DIR/server-name.conf
fi

# netplanのデフォルトをコピー
if [ -e $ROOT_DIR/netplan.conf.default ]; then
	cp -f $ROOT_DIR/netplan.conf.default $ROOT_DIR/netplan.conf
fi

# configのgtkrcをコピー
if [ -e $ROOT_DIR/config/gtkrc.conf ]; then
	cp -f $ROOT_DIR/config/gtkrc.conf $ROOT_DIR/ui/gtkrc
fi

# thicknessのデフォルト設定をコピー
if [ -e $ROOT_DIR/thickness.conf.default ]; then
	cp -f $ROOT_DIR/thickness.conf.default $ROOT_DIR/config/thickness.conf
fi

# resolv-head.confのデフォルト設定をコピー
if [ -e $ROOT_DIR/resolv-head.conf.default ]; then
	cp -f $ROOT_DIR/resolv-head.conf.default $ROOT_DIR/config/resolv-head.conf
fi

# カメラ時刻補正の工場出荷設定
TIMEAJUST_SETTING_FILE=$CONFIG_DIR/AutoTimeAdjustDisable.conf
# DMIを出力させるため管理者権限で行う。
DMI_NAME=`sudo dmidecode | grep -m 1 Product | grep AS | cut -d':' -f2`
# DMI品番よりRがある場合はカメラ時刻補正あり/ない場合は時刻補正なしとする
if [ $(echo $DMI_NAME | grep -e 'R') ]; then
	$ROOT_DIR/timeadj.sh ON > /dev/null 2>&1
else
	$ROOT_DIR/timeadj.sh OFF > /dev/null 2>&1
	sudo chown aile:aile $TIMEAJUST_SETTING_FILE
fi

sudo sync

sleep 1

touch $APP_SHUTDOWN_FILE

# #3334 Oops終了になってしまい、再起動されてしまう。
#sudo poweroff -f
sudo poweroff

### EOF ###