#!/usr/bin/perl
use strict;
use warnings;

use DateTime;
use Digest::SHA qw (sha1);
use MIME::Base64 qw (encode_base64);

use constant DEFAULT_USERNAME => "admin";
use constant DEFAULT_PASSWORD => "qwert";
use constant USERTOKEN_TMP => "<wsse:Security><wsse:UsernameToken><wsse:Username>%s</wsse:Username><wsse:Password Type=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#PasswordDigest\">%s</wsse:Password><wsse:Nonce>%s</wsse:Nonce><wsu:Created>%s</wsu:Created></wsse:UsernameToken></wsse:Security>";

my $ret = &main(\@ARGV);

sub main() {
	my $ret = 0;
	my $argv = $_[0];
	my $argc = @$argv;
	my $nonce = sha1(sha1(time() . {} . rand() . $$));
	my $username = DEFAULT_PASSWORD;
	my $password = DEFAULT_USERNAME;
	my $now = DateTime->now->iso8601 . 'Z';

	if ($argc >= 1) {
		$username = $$argv[0];
	}
	if ($argc >= 2) {
		$password = $$argv[1];
	}
	if ($argc >= 3) {
		$now = $$argv[2];
	}

	my $digest = encode_base64(sha1($nonce . $now . $password), '');
	my $usernameToken = sprintf(USERTOKEN_TMP, $username, $digest,  encode_base64($nonce, ''), $now);	

	printf("%s", $usernameToken);

	return $ret;
}

### EOF ###