#!/bin/bash
#######################################################
# 縦横表示
#######################################################

. /opt/aile/aile_common.sh

ROTATE_CONFIG="/opt/aile/config/DisplayRotate.conf"
VIEWER_CONFIG="/opt/aile/config/ViewerSetting.conf"
HwCheckCmd="/opt/aile/hwcheck"
solt=`date +"%Y%m%d%H%M%S"`
PRODUCT_FILE="/tmp/prdx2wr"
rotate_state="normal"

MODEL_4CH=`cat $PRODUCT_FILE | grep AS-8004 | wc -l`
if [ -e $VIEWER_CONFIG ]; then
	VIEWER_SPLIT=`cat $VIEWER_CONFIG | grep "ViewSplit" | awk -F':' '{print $2}'`
	if [ "$VIEWER_SPLIT" != "" ]; then
		if [ -e $ROTATE_CONFIG ]; then
			if [ $VIEWER_SPLIT = 8 -o $VIEWER_SPLIT = 9 -o $VIEWER_SPLIT = 13 ]; then
				DISPLAY_DIRECTION=`cat $ROTATE_CONFIG | awk -F'_' '{print $1}'`
				if [ "$DISPLAY_DIRECTION" = "vertical" ]; then
					rotate_state=`cat $ROTATE_CONFIG | awk -F'_' '{print $2}'`
				fi
			fi
		fi
	fi
	# 4ch版で2分割（縦）以外の回転は無効にする
	if [ $MODEL_4CH = 1 ]; then
		if [ $VIEWER_SPLIT != 8 -a $VIEWER_SPLIT != 13 ] && [ "$rotate_state" != "normal" ]; then
			rotate_state="normal"
		fi
	fi
fi

case $rotate_state in
	"left") ;;
	"right") ;;
	"inverted") ;;
	* ) rotate_state="normal" ;; 
esac

echo $rotate_state

### EOF ###