#!/bin/bash
#######################################################
# 解像度変更
#######################################################
IFS_BACKUP=$IFS
IFS=$'\n'

REQUIRE_RESOLUTION=1024
SCALE_MAX_RESOLUTION=4000
TARGET_RESOLUTION="1080"
MAX_RESOLUTION_SIZE=0
MIN_RESOLUTION_SIZE=$REQUIRE_RESOLUTION
RESOLUTION_X=0
RESOLUTION_Y=0
RESOLUTION_SIZE=0
XRANDR_STR=""

IN_VERTICAL=$2
IN_HORIZONTAL=$1

OUTPUT_ACTIVE_DISPLAYS=()
# 先に接続されたモニターが音声優先される
AUDIO_OUTPUT=`/opt/aile/get_audio_output.sh`
if [ "$AUDIO_OUTPUT" = "DP" ]; then
	OUTPUT_ACTIVE_DISPLAYS=(`xrandr  --current | grep " connect" | cut -d " " -f1 | sort -r`)
else
	OUTPUT_ACTIVE_DISPLAYS=(`xrandr  --current | grep " connect" | cut -d " " -f1`)
fi

for output_active_display in "${OUTPUT_ACTIVE_DISPLAYS[@]}";
do
	XRANDR_STR=`xrandr --current -q | grep "^"$output_active_display`
	if [ $(echo $XRANDR_STR | awk '{print $3}') = "primary" ]; then
		RESOLUTION_X=$(echo $XRANDR_STR | awk -F'[ +x]+' '{print $4}')
		RESOLUTION_Y=$(echo $XRANDR_STR | awk -F'[ +x]+' '{print $5}')
	else
		RESOLUTION_X=$(echo $XRANDR_STR | awk -F'[ +x]+' '{print $3}')
		RESOLUTION_Y=$(echo $XRANDR_STR | awk -F'[ +x]+' '{print $4}')
	fi
	if [[ $RESOLUTION_X =~ ^[0123456789]+$ ]]; then
		RESOLUTION_SIZE=`expr $RESOLUTION_X + $RESOLUTION_Y`
		if [ "$RESOLUTION_SIZE" -gt "$MAX_RESOLUTION_SIZE" ]; then
			MAX_RESOLUTION_SIZE=$RESOLUTION_SIZE
			if [ "$RESOLUTION_X" -gt "$RESOLUTION_Y" ]; then
				TARGET_RESOLUTION_Y=$TARGET_RESOLUTION
				TARGET_RESOLUTION_X=`echo "scale=0; $TARGET_RESOLUTION*$RESOLUTION_X/$RESOLUTION_Y" | bc`
			else
				TARGET_RESOLUTION_X=$TARGET_RESOLUTION
				TARGET_RESOLUTION_Y=`echo "scale=0; $TARGET_RESOLUTION*$RESOLUTION_Y/$RESOLUTION_X" | bc`
			fi
		fi
		if [ "$MIN_RESOLUTION_SIZE" -gt "$RESOLUTION_Y" ]; then
			MIN_RESOLUTION_SIZE=$RESOLUTION_Y
		fi
		if [ "$MIN_RESOLUTION_SIZE" -gt "$RESOLUTION_X" ]; then
			MIN_RESOLUTION_SIZE=$RESOLUTION_X
		fi
	fi
done

RESOLUTION_SCALE_X=`echo "scale=10; $TARGET_RESOLUTION_X/$IN_HORIZONTAL" | bc`
RESOLUTION_SCALE_Y=`echo "scale=10; $TARGET_RESOLUTION_Y/$IN_VERTICAL" | bc`

SCALEING_RESOLUTION_X=`echo "scale=0; $RESOLUTION_SCALE_X*$IN_HORIZONTAL" | bc`
SCALEING_RESOLUTION_Y=`echo "scale=0; $RESOLUTION_SCALE_Y*$IN_VERTICAL" | bc`

IFS=$IFS_BACKUP

echo $SCALEING_RESOLUTION_X"x"$SCALEING_RESOLUTION_Y

### EOF ###