#!/bin/bash

LOGGER="logger -t StartAile "

if [ $# -ne 1 ]; then
	echo "usage $0 service_name"
	exit -1
fi
service=$1

if [ "$service" = "" ]; then
	echo "invalid service name : [$1]"
	exit -1
fi

for loop in `seq 1 5`
do
	serviceStatus=`systemctl status $service | grep "Active:" | awk '{print $2}'`
	if [ "$serviceStatus" != "inactive" ]; then
		$LOGGER $service"(call stop)"
		sudo systemctl stop $service
	else
		break;
	fi
done

serviceStatus=`systemctl status $service | grep "Active:" | awk '{print $2}'`
if [ "$serviceStatus" != "active" ]; then
	$LOGGER $service"(stop failure)"
else
	$LOGGER $service"(stopped)"
fi

### EOF ###