#!/bin/bash

keys_display=("◀◀" "■" "❙❙" "▶▶" "▶" "戻る" "◁" "△" "▷" "▽"  "OK" "Focus+" "Focus-" "AUTO Focus" "CLEAR" "Zoom+" "Zoom-" "1" "2" "3" "4分割" "4" "5" "6" "9分割" "7" "8" "9" "16分割" "*(+10)" "0" "#" "CTM" "q" "w" "e" "r" "t" "y" "u" "i" "o" "p" "a" "s" "d" "f" "g" "h" "j" "k" "l" "BACKSPACE" "z" "x" "c" "v" "b" "n" "m" "." "△" "ENTER" "ESC" "CAPS" "ALTを押してから," "ALTを押してから◁" "▽" "▷")
keys=("[17~" "[15~" "OS" "[19~" "[18~" $'\x1b' "[D" "[A" "[C" "[B" "" "[20~" "[21~" "OQ" $'\x7F'  "[23~" "[24~" "1" "2" "3" "i" "4" "5" "6" "m" "7" "8" "9" "o" "*" "0" "#" "p" "q" "w" "e" "r" "t" "y" "u" "i" "o" "p" "a" "s" "d" "f" "g" "h" "j" "k" "l" $'\x7F' "z" "x" "c" "v" "b" "n" "m" "." "[A" "" $'\x1b' "" ";" "[D" "[B" "[C")

echo "リモコン動作チェックを開始します"
echo "動作チェックを強制停止するときはキーボードから[ctl]+[c]キーを押してください"

for ((i=0; i<${#keys[@]}; i++)); do
	while :
	do
		if [ "${keys_display[$i]}" == "◀◀" ]; then
			echo ""
			echo "【表面】のチェックを開始します。"
		fi
		if [ "${keys_display[$i]}" == "q" ]; then
			echo ""
			echo "【裏面】のチェックを開始します。"
			if [ "$(xset -q | grep Caps | awk '{print $4}')" = "on" ]; then
				echo "【CAPS】キーがONになっています。【CAPS】キーを押してOFFにしてからテストしてください。"
			fi
		fi
		if [ "${keys_display[$i]}" == "CAPS" ]; then
			state=$(xset -q | grep Caps | awk '{print $4}')
		fi
		echo "【"${keys_display[$i]}"】キーを入力してください。"
		case "${keys_display[$i]}" in
			"❙❙" | "AUTO Focus" | "◁" | "△" | "▽" | "ALTを押してから◁" | "▷" ) 
				read -r -s -n1 key
				if [ "$key" == $'\x1b' ]; then
					read -r -n2 -s derection_key
					if [ "$derection_key" = "${keys[$i]}" ]; then
						break
					fi
					echo "【エラー】"$derection_key"が入力されました。"
				fi
			;;
			"◀◀" | "■" | "▶▶" | "▶" | "Focus+" | "Focus-" | "Zoom+" | "Zoom-" ) 
				read -r -s -n1 key
				if [ "$key" == $'\x1b' ]; then
					read -r -n4 -s -t 1 derection_key
					if [ "$derection_key" = "${keys[$i]}" ]; then
						break
					fi
					echo "【エラー】"$derection_key"が入力されました。"
				fi
			;;
			"4分割" | "9分割" | "16分割" | "CTM" ) 
				key1=""
				key2=""
				read -r -s -n1 key1
				if [ "$key1" == $'\x1b' ]; then
					read -r -s -n3 -t1 key2
					if [ "$key2" == "OR${keys[$i]}" ]; then
						break
					else
						echo "【エラー】"${key1}${key2}"が入力されました。"
					fi
				elif [ "$key1" == "${keys[$i]}" ]; then
					read -r -s -n3 -t1 key2
					if [ "$key2" == $'\x1b'"OR" ]; then
						break
					else
						echo "【エラー】"${key1}${key2}"が入力されました。"
					fi
				else
					echo "【エラー】"${key1}"が入力されました。"
				fi
			;;
			"CAPS" ) 
				echo -n "【CAPS】キー入力待ち"
				while [ "$(xset -q | grep Caps | awk '{print $4}')" = "$state" ]
				do
					echo -n "・"
					sleep 1
				done
				echo  ""
				break
			;;
			* ) 
				read -r -s -n1 key
				if [ "$key" = "${keys[$i]}" ]; then
					break
				fi
				echo "【エラー】"$key"が入力されました。"
			;;
		esac
		read -r -s -t 0.1 key_dead
	done
done

state=$(xset -q | grep Caps | awk '{print $4}')
if [ "$state" = "on" ]; then
	echo "【CAPS】キーがONになっています。【CAPS】キーを押してOFFにしてください。"
	echo -n "【CAPS】キー入力待ち"
	while [ "$(xset -q | grep Caps | awk '{print $4}')" = "on" ]
	do
		echo -n "・"
		sleep 1
	done
	echo  ""
fi

echo  "チェックOKです。処理を完了します。"

### EOF ###