#! /usr/bin/perl
use strict;

our %hash_cameraname = ();
our %hash_modelname = ();

&main();

#---------------------------------
# メイン処理
#---------------------------------
sub main {

	my $video_rootpath = "/media/usbhdd/aileun";
#	my $config_path = "/home/aile/aile/config/CameraConfig.conf";
	my $config_path = "/opt/aile/config/CameraConfig.conf";
	
	my @maclist_camera = &get_maclist_camera($config_path);
	if ($#maclist_camera < 0) {
		print "$config_path から MACアドレスを見つけられませんでした\n";
		goto ERROR_EXIT;
	}

	my @filelist = &get_videofiles($video_rootpath);
	my @maclist_file = &get_maclist_file(@filelist);
	if ($#maclist_file < 0) {
		print "$video_rootpath 配下の録画ファイルから MACアドレスを見つけられませんでした\n";
		goto ERROR_EXIT;
	}

	&disp_maclist("録画ファイルのMACアドレス", @maclist_file);
	&disp_maclist("設定中カメラのMACアドレス", @maclist_camera);

	# 変更元、変更先のMAC(のIndex)を選択させる
	my $before_mac_index = &get_index("変更元(録画ファイルの)MAC", $#maclist_file);
	if ($before_mac_index < 0) {
		goto ERROR_EXIT;
	}
	my $after_mac_index = &get_index("変更先(設定中カメラの)MAC", $#maclist_camera);
	if ($after_mac_index < 0) {
		goto ERROR_EXIT;
	}

	my $before_mac = @maclist_file[$before_mac_index];
	my $after_mac = @maclist_camera[$after_mac_index];

	# リネームの実行
	my $rename_count = &rename_filename($before_mac, $after_mac, @filelist);
	print "$rename_count 個のファイルをリネームしました\n";

	return;

ERROR_EXIT:
	print "処理を中断しました\n";
	return;
}


#---------------------------------
# リネームする
#---------------------------------
sub rename_filename {
	my $before = shift;
	my $after = shift;
	my @filelist = @_;

	my $count = 0;

	foreach my $filename (@filelist) {

		if ($filename =~ /$before/) {
			my $oldname = $filename;
			$filename =~ s/$before/$after/;

#			print "before = $oldname\n";
#			print "after  = $filename\n";
#			print "\n";
			`mv $oldname $filename`;
			$count++;
		}
	}
	
	return $count;
}


#---------------------------------
# ユーザが入力したIndexを読み取る
#---------------------------------
sub get_index {
	my $disp_str = $_[0];
	my $maxindex = $_[1];
	
	my $ret = 0;

	while (1) {	
		printf("%sのIndexを入力してください(Index: 0-%d, 中止:Q)\n", $disp_str, $maxindex);
		my $input = <STDIN>;
		chomp($input);

		if (($input eq "Q") || ($input eq "q")) {
			$ret = -1;
			last;
		} elsif ( ($input =~ /^[0-9]+$/) && (0 <= $input) && ($input <= $maxindex)) {  # 数値かつ、範囲内かチェック
			$ret = $input;
			last;
		} else {
			print "入力エラー!!\n";
		}
	}
	return $ret;
}


#---------------------------------
# MACの一覧を表示(名前,モデル名が分かる場合はそれも)
#---------------------------------
sub disp_maclist {
	my $disp_str = shift;
	my @maclist = @_;
	
	my $itemnum = $#maclist;

	printf("==================================================\n");
	printf(" $disp_str\n");
	printf("--------------------------------------------------\n");
	for (my $i = 0; $i <= $itemnum; $i++) {
		my $mac = $maclist[$i];
		printf("%2d: %s  [%s (%s)]\n", $i, $mac, $hash_modelname{$mac}, $hash_cameraname{$mac});
	}
	printf("==================================================\n");
	printf("\n");
}

#---------------------------------
# CameraのConfigファイルからMACの一覧を作成
#---------------------------------
sub get_maclist_camera {
	my $configpath = $_[0];

	my @maclist = ();
	my $name = "unknown";
	my $model = "unknown";
	
	open(FH, "< $configpath");
	foreach my $line (<FH>) {
		# カメラ名取得
		if ($line =~/^Name:(.*)/) {
			$name = $1;
		}
		if ($line =~/^ModelName:(.*)/) {
			$model = $1;
		}
		# MACアドレス取得
		if ($line =~/^Mac:([0-9a-fA-F]{2}):([0-9a-fA-F]{2}):([0-9a-fA-F]{2}):([0-9a-fA-F]{2}):([0-9a-fA-F]{2}):([0-9a-fA-F]{2})/) {
			my $mac = "$1$2$3$4$5$6";
			push(@maclist, $mac);
			#print "$mac\n";
		
			# カメラ名、モデル名をテーブルに追加しておく	
			$hash_cameraname{$mac} = $name;
			$hash_modelname{$mac} = $model;
			$name = "unknown";
		}
	}
	return @maclist;
}

#---------------------------------
# 録画ファイル名の一覧から、MACの一覧を作成
#---------------------------------
sub get_maclist_file {
	my @filelist = @_;

	my @maclist = ();
	
#	printf("==============リネーム候補検索 開始==============\n");

	foreach my $filename (@filelist) {

		# macアドレス部分(12桁の0-9,a-f,A-F)を抽出
		if ($filename =~ /\/([0-9a-fA-F]{12})_/) {
#			print "発見: $filename\n";
			push(@maclist, $1);
		}
	}
	
	# 重複要素を削除
	my %count;
	@maclist = grep(!$count{$_}++, @maclist);
	@maclist = sort(@maclist);
	#print "@maclist\n";

#	printf("==============リネーム候補検索 完了==============\n");
#	printf("\n");

	return @maclist;
}

#---------------------------------
# 録画ファイル名一覧を取得
#---------------------------------
sub get_videofiles {
	my $root = $_[0];
	#print "path = $root\n";

	my @filelist = `find $root -name "*.*"`;
	#print @filelist;

	# 各行末の改行を削除
	for (my $i = 0; $i <= $#filelist; $i++) {
		chomp(@filelist[$i]);
	}
	return @filelist;
}

### EOF ###