#!/bin/bash

AILE_DIR=/opt/aile
LOGGER="logger -t ntp-datesync"

if [ $# -ge 1 ]; then
	OPTS="-b"
else
	OPTS="-B"
fi

service ntp stop
DNSPROC=`ps auxw | grep dnsmasq | grep -v grep | awk '{print $2}'`
if [ "$DNSPROC" == "" ]; then
	service dnsmasq start
	sleep 1
fi

# ntp設定存在チェック
AILE_NTP_CONF=$AILE_DIR/config/ntp.conf
if [ ! -r $AILE_NTP_CONF ]; then
	$LOGGER "ntp.conf not found"
	exit 0
fi

AILE_NTP_SERVER=
exec 3< $AILE_NTP_CONF
while read AILE_NTP_SERVER_TMP 0<&3
do
	case $AILE_NTP_SERVER_TMP in
	SERVER=*)
		AILE_NTP_SERVER=${AILE_NTP_SERVER_TMP#SERVER=}
		$LOGGER "ntpserver: $AILE_NTP_SERVER" || :
		;;
	*)
		;;
	esac
done
exec 3<&-

if [ -z $AILE_NTP_SERVER ]; then
	$LOGGER "ntp-server not configured"
	exit 0
fi

#3246 IPV4だけでいい
ntpdate -4 -d $AILE_NTP_SERVER | $LOGGER

if ntpdate -s $OPTS $AILE_NTP_SERVER 2>/dev/null ; then
	$LOGGER "SUCCESS" || :
	NTPDATE_EXIT_STATUS=0
else
	$LOGGER "FAILED" || :
	NTPDATE_EXIT_STATUS=1
fi

if [ $NTPDATE_EXIT_STATUS -eq 0 ]; then
	hwclock --rtc=/dev/rtc0 --systohc --utc --noadjfile
fi

exit $NTPDATE_EXIT_STATUS

### EOF ###