#!/bin/sh

DMI_NAME=`sudo dmidecode | grep -m 1 Product | grep AS | cut -d':' -f2`
AUDIO_LOOP=0
SOFT_VERSION=`head -n 1 /opt/aile/version.txt`
MEM_TOTAL=`awk '{ printf "%.2f", $2/1024/1024 ; exit}' /proc/meminfo | sed s/\.[0-9,]*$//g`

ifconfig eth0 > /dev/null
if [ $? -ne 0 ]
then
	echo "【LANデバイス異常。再インストール実施してください。（それでもNGであればハード異常です）】"
fi

# DMI品番を表示する
echo "DMIは【"$DMI_NAME" 】です"

# メモリ容量チェック #3336 7036→8036、12GB→16GB
if [ $(echo $DMI_NAME | grep -e '8036') ]
then
	if [ $MEM_TOTAL -lt 9 ]
	then
		echo "【メモリ容量に問題があります。"$DMI_NAME"には16GBのメモリが必要です】"
	fi
fi

# ソフトバージョンを表示する
echo "バージョンは【V"$SOFT_VERSION" 】です"

# 音声出力テストを行う。
echo "音声出力を開始します"
while [ $AUDIO_LOOP -ne 3 ]
do
	aplay /usr/share/sounds/alsa/Noise.wav > /dev/null 2>&1
	AUDIO_LOOP=$(( $AUDIO_LOOP + 1 ))
done
echo "音声出力を終了しました"

### EOF ###