#!/bin/bash

SETTING_FILE=/opt/aile/config/RebootSchedule.conf

function printUsage() {
	echo "USAGE :"
	echo " $0 OFF"
	echo "  定時再起動を無効化(デフォルト)"
	echo " $0 ON"
	echo "  定時再起動を有効化(続けて時刻入力になります)"
	echo "再度、正しい設定を入力してください。"
}


if [ $# -ne 1 ]; then
	printUsage
	exit 1;
fi

if [ $1 == "OFF" ]; then
	if [ -e $SETTING_FILE ]; then
		rm $SETTING_FILE 2>&1 > /dev/null
	fi
	echo "定時再起動を無効にしました。"
elif [ $1 == "ON" ]; then
	echo "時間を入れてください( 00 - 23 )"
	read hour
	echo $hour | egrep "^[0-9][0-9]?$" > /dev/null 2>&1
	if [ $? -ne 0 ];then
		echo "値が不正です。再設定してください"
		exit 1;
	elif [ $hour -ge 24 ] ; then
		echo "値が不正です。再設定してください"
		exit 1;
	fi
	echo "分を入れてください( 00 - 59 )"
	read min
	echo $min | egrep "^[0-9][0-9]?$" > /dev/null 2>&1
	if [ $? -ne 0 ];then
		echo "値が不正です。再設定してください"
		exit 1;
	elif [ $min -ge 60 ] ; then
		echo "値が不正です。再設定してください"
		exit 1;
	fi
	echo "$hour:$min" > $SETTING_FILE
	echo "$hour:$minに定時再起動を設定しました。"
else
	printUsage
	exit 1;
fi

### EOF ###