#!/bin/bash
#######################################################
# ミラーリング
#######################################################

. /opt/aile/aile_common.sh

OUTPUT_ACTIVE_DISPLAYS=()
OUTPUT_ACTIVE_DISPLAYS=(`xrandr --current | grep " connect" | cut -d " " -f1`)

logger -t $0 "Display Count: ${#OUTPUT_ACTIVE_DISPLAYS[@]}"
if [ "${#OUTPUT_ACTIVE_DISPLAYS[@]}" -ge 2 ]; then
	if pgrep compton > /dev/null; then
		logger -t $0 "Stop Compton"
		pkill compton
	fi
else
	if ! pgrep compton > /dev/null; then
		DISPLAY_RATE=(`/opt/aile/getMonitorRefreshRate.sh`)
		DISPLAY_RATE=${DISPLAY_RATE:-60}
		DISPLAY_RATE=${DISPLAY_RATE%.*}
		logger -t $0 "Start Compton Rate=$DISPLAY_RATE"
		/opt/aile/exec-compton.sh $DISPLAY_RATE
	fi
fi

### EOF ###