#!/bin/bash
#######################################################
# ミラーリング
#######################################################

. /opt/aile/aile_common.sh

OUTPUT_ACTIVE_DISPLAYS=()
# 先に接続されたモニターが音声優先される
AUDIO_OUTPUT=`/opt/aile/get_audio_output.sh`
if [ "$AUDIO_OUTPUT" = "DP" ]; then
	OUTPUT_ACTIVE_DISPLAYS=(`xrandr --current | grep " connect" | cut -d " " -f1 | sort -r`)
else
	OUTPUT_ACTIVE_DISPLAYS=(`xrandr --current | grep " connect" | cut -d " " -f1`)
fi

for display in `xrandr --current | grep " disconnect" | cut -d " " -f1`
do
	xrandr --output $display --off
done

PRIMARY_DISPLAY=${OUTPUT_ACTIVE_DISPLAYS[0]}
MAX_PIXELS=0
MAX_RES=""

#解像度の高いモニタをPrimaryとする
for output_active_display in "${OUTPUT_ACTIVE_DISPLAYS[@]}";
do
    if [ "$output_active_display" = "DP-2" ]; then
		# エルーア8では、DP-2がVGAなので、OFFへ
		xrandr --output $output_active_display --off
        continue
    fi
	xrandr --output $output_active_display --auto
	tmp_default_mode=`/opt/aile/monitor-utility $output_active_display 1`
	if [ "$tmp_default_mode" != "" ]; then
			WIDTH=$(echo "$tmp_default_mode" | cut -d'x' -f1)
			HEIGHT=$(echo "$tmp_default_mode" | cut -d'x' -f2)
			PIXELS=$((WIDTH * HEIGHT))
			if (( PIXELS > MAX_PIXELS )); then
				PRIMARY_DISPLAY=$output_active_display
				MAX_PIXELS=$PIXELS
				MAX_RES=$tmp_default_mode
			fi
	fi
done

#スケーリングして、解像度の低いモニタへミラーリングする
for MIRROR_DISPLAY in "${OUTPUT_ACTIVE_DISPLAYS[@]}";
do
    if [ "$MIRROR_DISPLAY" = "DP-2" ]; then
        continue
    fi

    if [ "$MIRROR_DISPLAY" != "$PRIMARY_DISPLAY" ]; then
                tmp_default_mode=`/opt/aile/monitor-utility $MIRROR_DISPLAY 1`
                xrandr --output $MIRROR_DISPLAY --mode $tmp_default_mode --scale-from $MAX_RES --same-as $PRIMARY_DISPLAY
                logger -t $0 "Mode modify Monitor: $MIRROR_DISPLAY Mode: $tmp_default_mode"
                logger -t $0 "Mirroring $PRIMARY_DISPLAY to $MIRROR_DISPLAY"
    fi
done

### EOF ###