#!/bin/bash
#######################################################
# 解像度変更
#######################################################

. /opt/aile/aile_common.sh

IFS_BACKUP=$IFS
IFS=$'\n'

MIN_WIDTH=1024
MIN_HEIGHT=1080

if [ -e $APP_LUCK_RESOLUTION ]; then
	rm -f $APP_LUCK_RESOLUTION
fi

OUTPUT_ACTIVE_DISPLAYS=()
# 先に接続されたモニターが音声優先される
AUDIO_OUTPUT=`/opt/aile/get_audio_output.sh`
if [ "$AUDIO_OUTPUT" = "DP" ]; then
	OUTPUT_ACTIVE_DISPLAYS=(`xrandr --current | grep " connect" | cut -d " " -f1 | sort -r`)
else
	OUTPUT_ACTIVE_DISPLAYS=(`xrandr --current | grep " connect" | cut -d " " -f1`)
fi

for output_active_display in "${OUTPUT_ACTIVE_DISPLAYS[@]}";
do
	if [ "$output_active_display" = "DP-2" ]; then
		# エルーア8では、DP-2がVGAなので、OFFへ
		xrandr --output $output_active_display --off
		continue
	fi

	# 4kにするには引数を変える
	set_mode=`/opt/aile/monitor-utility $output_active_display 2`
	if [ "$set_mode" != "" ]; then
		mode_width=`echo $set_mode | awk -F"x" '{print $1}' | sed -e 's/[^0-9]//g'`
		mode_height=`echo $set_mode | awk -F"x" '{print $2}' | sed -e 's/[^0-9]//g'`
		xrandr --output $output_active_display --scale 1x1
		logger -t $0 "Monitor: $output_active_display Mode: $set_mode"
		xrandr --output $output_active_display --mode $set_mode
		if [ $mode_width -lt $MIN_WIDTH ] || [ $mode_height -lt $MIN_HEIGHT ]; then
			touch $APP_LUCK_RESOLUTION
		fi
	else
		logger -t $0 "Not get default mode"
		touch $APP_LUCK_RESOLUTION
	fi
done

IFS=$IFS_BACKUP

### EOF ###