#!/bin/bash
#######################################################
# 縦横表示
#######################################################

. /opt/aile/aile_common.sh

ROTATE_CONFIG="/opt/aile/config/DisplayRotate.conf"
VIEWER_CONFIG="/opt/aile/config/ViewerSetting.conf"
HwCheckCmd="/opt/aile/hwcheck"
solt=`date +"%Y%m%d%H%M%S"`
PRODUCT_FILE="/tmp/prdx2wr"
ROTATE="normal"

MODEL_4CH=`cat $PRODUCT_FILE | grep AS-8004 | wc -l`
if [ -e $VIEWER_CONFIG ]; then
	VIEWER_SPLIT=`cat $VIEWER_CONFIG | grep "ViewSplit" | awk -F':' '{print $2}'`
	if [ -e $ROTATE_CONFIG ]; then
		if [ $VIEWER_SPLIT = 8 -o $VIEWER_SPLIT = 9 -o $VIEWER_SPLIT = 13 ]; then
			DISPLAY_DIRECTION=`cat $ROTATE_CONFIG | awk -F'_' '{print $1}'`
			if [ "$DISPLAY_DIRECTION" = "vertical" ]; then
				ROTATE=`cat $ROTATE_CONFIG | awk -F'_' '{print $2}'`
			fi
		fi
	fi
	# 4ch版で2分割（縦）以外の回転は無効にする
	if [ $MODEL_4CH = 1 ]; then
		if [ $VIEWER_SPLIT != 8 -a $VIEWER_SPLIT != 13 ] && [ "$ROTATE" != "normal" ]; then
			ROTATE="normal"
		fi
	fi
fi

case $ROTATE in
	"left") ;;
	"right") ;;
	"inverted") ;;
	* ) ROTATE="normal" ;; 
esac

EXECUTE_ROTATE=0
OUTPUT_ACTIVE_DISPLAYS=()
# 先に接続されたモニターが音声優先される
AUDIO_OUTPUT=`/opt/aile/get_audio_output.sh`
if [ "$AUDIO_OUTPUT" = "DP" ]; then
	OUTPUT_ACTIVE_DISPLAYS=(`xrandr --current | grep " connect" | cut -d " " -f1 | sort -r`)
else
	OUTPUT_ACTIVE_DISPLAYS=(`xrandr --current | grep " connect" | cut -d " " -f1`)
fi

for output_active_display in "${OUTPUT_ACTIVE_DISPLAYS[@]}";
do
	cur_rotate=""
	XRANDR_RESULT=`xrandr --current -q | grep "$output_active_display connected"`
	primary=`echo $XRANDR_RESULT | awk '{print $3}'`
	if [ "$primary" = "primary" ]; then
		cur_rotate=`echo $XRANDR_RESULT | awk '{print $5}'`
	else
		cur_rotate=`echo $XRANDR_RESULT | awk '{print $4}'`
	fi
	if [ "$cur_rotate" != "" ] && [ $ROTATE = "left" ] && [ "$cur_rotate" != "left" ]; then
		EXECUTE_ROTATE=1
	fi
	if [ "$cur_rotate" != "" ] && [ $ROTATE = "right" ] && [ "$cur_rotate" != "right" ]; then
		EXECUTE_ROTATE=1
	fi

	if [ "$output_active_display" = "DP-2" ]; then
		# エルーア8では、DP-2がVGAなので、OFFへ
		xrandr --output $output_active_display --off
		continue
	fi

	default_mode=`/opt/aile/monitor-utility $output_active_display 3`
	if [ "$default_mode" = "" ]; then
		tmp_default_mode=`/opt/aile/monitor-utility $output_active_display 1`
		if [ "$tmp_default_mode" != "" ]; then
			logger -t $0 "Rotate modify Monitor: $output_active_display Mode: $tmp_default_mode"
			xrandr --output $output_active_display --mode $tmp_default_mode
		fi
	fi
done

if [ $ROTATE = "left" ] || [ $ROTATE = "right" ]; then
	touch $NOTIFY_ROTATION_FILE
	for output_active_display in "${OUTPUT_ACTIVE_DISPLAYS[@]}";
	do
		if [ "$output_active_display" = "DP-2" ]; then
			# エルーア8では、DP-2がVGAなので、OFFへ
			xrandr --output $output_active_display --off
			continue
		fi
		if [ $EXECUTE_ROTATE -eq 0 ]; then
			break;
		fi
		xrandr --output $output_active_display --scale 1x1
		logger -t $0 "Try Rotate modify Monitor: $output_active_display ${ROTATE} -- try `expr $i + 1` times"
		xrandr --output $output_active_display --auto --rotate $ROTATE
	done
fi

### EOF ###