#!/bin/bash
#######################################################
# alter link 20-intel.conf
#######################################################
ROTATE_CONFIG="/opt/aile/config/DisplayRotate.conf"
VIEWER_CONFIG="/opt/aile/config/ViewerSetting.conf"
ROTATE="normal"

MODEL_4CH=`dmidecode -t system | grep "Product Name:" | awk -F' ' '{print $3}' | grep "AS-8004" | wc -l`
if [ -e $VIEWER_CONFIG ]; then
	VIEWER_SPLIT=`cat $VIEWER_CONFIG | grep "ViewSplit" | awk -F':' '{print $2}'`
	if [ -e $ROTATE_CONFIG ]; then
		if [ $VIEWER_SPLIT = 8 -o $VIEWER_SPLIT = 9 -o $VIEWER_SPLIT = 13 ]; then
			ROTATE="normal"
			DISPLAY_DIRECTION=`cat $ROTATE_CONFIG | awk -F'_' '{print $1}'`
			if [ "$DISPLAY_DIRECTION" = "vertical" ]; then
				ROTATE=`cat $ROTATE_CONFIG | awk -F'_' '{print $2}'`
			fi
		fi
	fi
	# 4ch版で2分割（縦）以外の回転は無効にする
	if [ $MODEL_4CH = 1 ]; then
		if [ $VIEWER_SPLIT != 8 -a $VIEWER_SPLIT != 13 ] && [ "$ROTATE" != "normal" ]; then
			ROTATE="normal"
		fi
	fi
fi

ln -fs /opt/aile/20-intel.conf.$ROTATE /usr/share/X11/xorg.conf.d/20-intel.conf

### EOF ###