#!/bin/bash
AILE_DIR=/opt/aile

LOGGER="logger -t aile.sh "

touch /tmp/ntp-sync.lock
${AILE_DIR}/Xserver-monitoring.sh

if [ ! -e "${AILE_DIR}" ]; then
	mkdir ${AILE_DIR}
	chmod 777 ${AILE_DIR}
	chown aile:aile ${AILE_DIR}
fi
export DISPLAY=:0.0

AUDIO_OUTPORT=`/opt/aile/get_audio_output.sh`

$LOGGER "Set up Audio port to $AUDIO_OUTPORT"

ALSA_CONF_FILE=/usr/share/alsa/alsa.conf
ASOUND_STATE_FILE=/var/lib/alsa/asound.state
PULSE_DEFAULT_PA_FILE=/etc/pulse/default.pa
if [ "$AUDIO_OUTPORT" = "JACK" ]; then
	cp $ALSA_CONF_FILE.jack $ALSA_CONF_FILE
	cp $ASOUND_STATE_FILE.jack $ASOUND_STATE_FILE
	cp $PULSE_DEFAULT_PA_FILE.jack $PULSE_DEFAULT_PA_FILE
elif [ "$AUDIO_OUTPORT" = "HDMI" ]; then
	cp $ALSA_CONF_FILE.hdmi $ALSA_CONF_FILE
	cp $ASOUND_STATE_FILE.hdmi $ASOUND_STATE_FILE
	cp $PULSE_DEFAULT_PA_FILE.hdmi $PULSE_DEFAULT_PA_FILE
else
	cp $ALSA_CONF_FILE.dp $ALSA_CONF_FILE
	cp $ASOUND_STATE_FILE.dp $ASOUND_STATE_FILE
	cp $PULSE_DEFAULT_PA_FILE.dp $PULSE_DEFAULT_PA_FILE
fi
#service rsyslog restart
alsactl restore
swapoff -a

exec /opt/aile/startup.sh

exit 0
