#!/bin/bash

SETTING_FILE=/opt/aile/config/AutoTimeAdjustDisable.conf

function printUsage() {
	echo "USAGE :"
	echo " $0 ON"
	echo "  自動時刻補正を有効化(デフォルト)"
	echo " $0 OFF"
	echo "  自動時刻補正を無効化"
	echo "再度、正しい設定を入力してください。"
}


if [ $# -ne 1 ]; then
	printUsage
	exit 1;
fi

if [ $1 == "ON" ]; then
	if [ -e $SETTING_FILE ]; then
		rm $SETTING_FILE 2>&1 > /dev/null
	fi
	echo "自動時刻補正を有効にしました。"
elif [ $1 == "OFF" ]; then
	touch $SETTING_FILE 2>&1 > /dev/null
	echo "自動時刻補正を無効にしました。"
else
	printUsage
	exit 1;
fi

### EOF ###