#!/bin/bash
logger "uncompressAileConfig Start."
# Aileunの最新モデル番号
AILEUN_LAST_MODEL_NUMBER=8
# Aileunの一番古いモデル番号
AILEUN_OLDEST_MODEL_NUMBER=1

TMP_DIR=/opt/aile/uploaded
AILE_DIR=/opt/aile
AILEUN_DIR=$TMP_DIR/aileun_8
WORK_DIR=$AILEUN_DIR/config
COMPRESS_FILE=$TMP_DIR/aileun_8.zip
AILE_CONFIG_DIR=$AILE_DIR/config
AILE_CONFIG_BAK_DIR=$TMP_DIR/config_bak
AILE_UI_DIR=$AILE_DIR/ui
DONT_REMOVE_FILE_LIST=$AILE_DIR/dont_remove.list

### アップロードしたconfigを展開
if [ ! -e $COMPRESS_FILE ]; then
    # Zipファイルがなければ何もしない。
	logger "uncompressAileConfig End. no zip."
	exit 0
fi

logger "unzip ..."
cd $TMP_DIR
sudo unzip $COMPRESS_FILE > /dev/null

# 最新のモデルから設定ファイルのディレクトリを検索
# 見つからなければ下位モデルのディレクトリを検索していく
for no in `seq $AILEUN_LAST_MODEL_NUMBER -1 $AILEUN_OLDEST_MODEL_NUMBER`
do
	AILEUN_DIR=`printf "%s/aileun_%d" $TMP_DIR $no`
	WORK_DIR=`printf "%s/config" $AILEUN_DIR`
	if [ -e $WORK_DIR ]; then
		break
	fi
done

sudo chown aile:aile $WORK_DIR/* 

sudo mv $WORK_DIR/* $AILE_CONFIG_DIR/

if [ -e $AILE_CONFIG_DIR/gtkrc.conf ]; then
	sudo cp -f $AILE_CONFIG_DIR/gtkrc.conf $AILE_UI_DIR/gtkrc
fi

# netplan.confの移動
if [ -e $AILE_CONFIG_DIR/netplan.conf ]; then
	mv $AILE_CONFIG_DIR/netplan.conf $AILE_DIR/netplan.conf
fi

sudo rm -fr $COMPRESS_FILE $AILEUN_DIR $TMP_DIR

# aile8未満の設定ファイルをロードした場合は、CustomSequence.confを削除する。
# 8の場合はロードしたのを上書きで良いが、7とかは持っていないので。
if [ $no -lt $AILEUN_LAST_MODEL_NUMBER ]; then
    CONF_PATH=`printf "%s/CustomSequence.conf" $AILE_CONFIG_DIR`
    [ -e $CONF_PATH ] && rm "$CONF_PATH"
fi


logger "uncompressAileConfig End."
