/***************************************************************************
 * aile_common_lib.h
 *
 *  Wed Oct 20 18:30:47 2010
 *  Copyright  2010  aile
 *  <aile@<host>>
 ****************************************************************************/
#ifndef __AILE_COMMON_LIB_H__
#define __AILE_COMMON_LIB_H__

#include <errno.h>
#include <fcntl.h>
#include <limits.h>
#include <signal.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <syslog.h>
#include <time.h>
#include <unistd.h>

#define IGNORE_EXIT_CODE 0x0000

#define STARTUP_WAITING_SLEEP_SEC 1
//#3413 まれにaileが起動してこないときがあり、１０分は長いとのこと。
#define STARTUP_WAITING_COUNT 30

typedef struct _TProcessInfo {
    const char *file_name;
    const char *process_name;
    unsigned int always_exist;
} TProcessInfo;

#define SLOG_ERROR(proc_name, fmt, ...)                             \
    AileCommLib_Logout(__FUNCTION__, __LINE__, proc_name, "E", fmt, \
                       ##__VA_ARGS__)
#define SLOG_WARNING(proc_name, fmt, ...)                           \
    AileCommLib_Logout(__FUNCTION__, __LINE__, proc_name, "W", fmt, \
                       ##__VA_ARGS__)
#define SLOG_INFO(proc_name, fmt, ...)                              \
    AileCommLib_Logout(__FUNCTION__, __LINE__, proc_name, "I", fmt, \
                       ##__VA_ARGS__)
#define SLOG_DEBUG(proc_name, fmt, ...)                             \
    AileCommLib_Logout(__FUNCTION__, __LINE__, proc_name, "D", fmt, \
                       ##__VA_ARGS__)

#define SLOG_ERROR_PRNT(proc_name, fmt, ...)                           \
    AileCommLib_LogoutStd(__FUNCTION__, __LINE__, proc_name, "E", fmt, \
                          ##__VA_ARGS__)
#define SLOG_INFO_PRNT(proc_name, fmt, ...)                            \
    AileCommLib_LogoutStd(__FUNCTION__, __LINE__, proc_name, "I", fmt, \
                          ##__VA_ARGS__)
#define SLOG_DEBUG_PRNT(proc_name, fmt, ...)                           \
    AileCommLib_LogoutStd(__FUNCTION__, __LINE__, proc_name, "D", fmt, \
                          ##__VA_ARGS__)

void AileCommLib_Logout(const char *func, int line, const char *proc_name,
                        char *log_type, char *fmt, ...);
void AileCommLib_LogoutStd(const char *func, int line, const char *proc_name,
                           char *log_type, char *fmt, ...);

int AileCom_NanoSleepSignalSafe(time_t in_sec, long in_nanosec);
int AileCom_GetProcessPID(const char *file_name);
int AileCom_CheckProcessState(const int own_pid, const TProcessInfo *info);
int AileCom_AileunProcStartupWaiting(const int own_pid,
                                     const TProcessInfo *info,
                                     int (*execute_func)(int), int exit_code);

#endif  //__AILE_COMMON_LIB_H__