#!/bin/sh
#
# Aileun external conroler Updater

LOGGER="logger -t aile_install "
INSTALL_DIR=/opt
AILE_EXCTRL_PKG_DIR=$INSTALL_DIR/aile_exctrl
AILE_EXCTRL_PKG=$AILE_EXCTRL_PKG_DIR/aile-exctrl.tar.gz
AILE_EXCTRL_DIR=$INSTALL_DIR/aile-exctrl
CHKTMP_DIR=/tmp/aile-exctrl
CHECKSUM_FILE=aileun-exctrl.txt
DEFAULT_DIR=`pwd`

if [ -e $AILE_EXCTRL_PKG ] ; then
	mkdir -p $CHKTMP_DIR
	tar zxvfp $AILE_EXCTRL_PKG -C $CHKTMP_DIR
	cd $CHKTMP_DIR/aile-exctrl
	if [ -e $CHECKSUM_FILE ]; then
		md5sum -c $CHECKSUM_FILE
		if [ $? -eq 0 ]; then
			tar zxvfp $AILE_EXCTRL_PKG -C $INSTALL_DIR
			sh $AILE_EXCTRL_DIR/install.sh $INSTALL_DIR
			sync
			sync
			sync
			rm -f $AILE_EXCTRL_DIR/install.sh
			rm -f $AILE_EXCTRL_DIR/$CHECKSUM_FILE
		else
			$LOGGER "Aile-ExCtrl Software Validation : NG, VersionUP Faild."
			rm -f $AILECTRL_PKG
		fi
	else
		$LOGGER "NOT FOUND MD5 CHECKSUM File. Aile-ExCtrl Software Validation and UpdateProcess will be Faild."
		rm -f $AILECTRL_PKG
	fi

	cd $DEFAULT_DIR
	rm -rf $CHKTMP_DIR
fi
sync
