#!/bin/sh

INSTALL_DIR=/opt

if [ $# -gt 0 -a -d $1 ] ; then
	INSTALL_DIR=$1
fi

if [ $(cat /etc/group | grep video | grep aile | wc -l) -eq 0 ]; then
	usermod -a -G video aile
fi

HWWATCHDOG_PKG=$INSTALL_DIR/watchdog
if [ -d $HWWATCHDOG_PKG ]; then
	cd $HWWATCHDOG_PKG
	sh install.sh
	cd ..
	rm -fr $HWWATCHDOG_PKG
fi

DRIVER_PKG=$INSTALL_DIR/driver
if [ -d $DRIVER_PKG ] ; then
	cd $DRIVER_PKG
	sh install.sh
	cd ..
	rm -rf $DRIVER_PKG
fi

if [ -e $INSTALL_DIR/REQUIRE_REBOOT ]; then
	rm $INSTALL_DIR/REQUIRE_REBOOT
	logger -t driver_update "reboot check"
	reboot
fi

# ローカルリポジトリの配置
#if [ -e $INSTALL_DIR/package/extras.tgz ]; then
#	mv $INSTALL_DIR/package/extras.tgz $INSTALL_DIR/extras.tgz
#	tar zxf $INSTALL_DIR/extras.tgz
#	# 追加パッケージのインストール
#	if [ -e $INSTALL_DIR/package-install.sh ]; then
#		bash $INSTALL_DIR/package-install.sh
#		rm -rf $INSTALL_DIR/package-install.sh
#	fi
#	rm -rf $INSTALL_DIR/extras
#	rm -rf $INSTALL_DIR/extras.tgz
#fi

# systemdのサービスで使うスクリプトの配置
if [ -e $INSTALL_DIR/aile/systemd ]; then
	mv $INSTALL_DIR/aile/systemd/* $INSTALL_DIR/systemd/aile/bin/
	chmod 755 $INSTALL_DIR/systemd/aile/bin/*
	rm -rf $INSTALL_DIR/aile/systemd
	if [ -e $INSTALL_DIR/aile/systemdconfig ]; then
		# WatchingMonitorのconfig
		if [ ! -e $INSTALL_DIR/systemd/aile/config/watching-monitor ]; then
			mkdir $INSTALL_DIR/systemd/aile/config/watching-monitor
		fi
		mv $INSTALL_DIR/aile/systemdconfig/watching-monitor/* $INSTALL_DIR/systemd/aile/config/watching-monitor/
		# 所有者変更
		chown -R aile:aile $INSTALL_DIR/systemd/aile/config/*
		rm -rf $INSTALL_DIR/aile/systemdconfig
	fi
fi

# systemdのサービスの配置
if [ -e $INSTALL_DIR/package/aileservice ]; then
	aileServiceList=$INSTALL_DIR/package/aileservice/serviceEnableList.conf
	mv $INSTALL_DIR/package/aileservice/*.service /etc/systemd/system/
	while read service
	do
		serviceName=`echo $service | awk -F':' '{print $1}'`
		serviceEnable=`echo $service | awk -F':' '{print $2}'`
		# サービス登録
		systemctl $serviceEnable $serviceName
		if [ "$serviceEnable" = "enable" ]; then
			systemctl start $serviceName
		fi
	done < ${aileServiceList}
fi

# netplanの設定を配置（初回のみ）
if [ -e $INSTALL_DIR/package/netplan.conf ]; then
	if [ ! -e $INSTALL_DIR/aile/netplan.conf.default ]; then
		cp $INSTALL_DIR/package/netplan.conf $INSTALL_DIR/aile/netplan.conf.default
		chmod 755 $INSTALL_DIR/aile/netplan.conf.default
		chown aile:aile $INSTALL_DIR/aile/netplan.conf.default
	fi
	if [ ! -e $INSTALL_DIR/aile/netplan.conf ]; then
		cp $INSTALL_DIR/package/netplan.conf $INSTALL_DIR/aile/netplan.conf
		chmod 755 $INSTALL_DIR/aile/netplan.conf
		chown aile:aile $INSTALL_DIR/aile/netplan.conf
	fi
fi

if [ ! -e /etc/netplan/01-netcfg.yaml.org ]; then
	mv /etc/netplan/01-netcfg.yaml /etc/netplan/01-netcfg.yaml.org
fi
if [ ! -e /etc/netplan/01-netcfg.yaml ]; then
	if [ -e $INSTALL_DIR/aile/netplan.conf ]; then
		ln -fs $INSTALL_DIR/aile/netplan.conf /etc/netplan/01-netcfg.yaml
		netplan apply
	fi
fi

# thickness.confをconfigの下に移動（初回のみ）
if [ -e $INSTALL_DIR/package/thickness.conf ]; then
	if [ ! -e $INSTALL_DIR/aile/config/thickness.conf ]; then
		cp $INSTALL_DIR/package/thickness.conf $INSTALL_DIR/aile/config/thickness.conf
		chmod 666 $INSTALL_DIR/aile/config/thickness.conf
		chown aile:aile $INSTALL_DIR/aile/config/thickness.conf
	fi
	if [ ! -e $INSTALL_DIR/aile/thickness.conf.default ]; then
		cp $INSTALL_DIR/package/thickness.conf $INSTALL_DIR/aile/thickness.conf.default
		chmod 666 $INSTALL_DIR/aile/thickness.conf.default
		chown aile:aile $INSTALL_DIR/aile/thickness.conf.default
	fi
fi

# アラーム音
if [ -e $INSTALL_DIR/package/snd ]; then
	cp -ar $INSTALL_DIR/package/snd $INSTALL_DIR/aile/
	chmod -R 777 $INSTALL_DIR/aile/snd
	chown -R aile:aile $INSTALL_DIR/aile/snd
fi

# 表示準備ビデオ
if [ -e $INSTALL_DIR/video ]; then
	cp -ar $INSTALL_DIR/video $INSTALL_DIR/aile/
	chmod -R 755 $INSTALL_DIR/aile/video
	chown -R aile:aile $INSTALL_DIR/aile/video
fi

# DNS対応(DNSキャッシュサーバの設定)
if [ -e $INSTALL_DIR/package/dnsmasq.conf ]; then
	if [ ! -e /etc/dnsmasq.conf.org ]; then
		mv /etc/dnsmasq.conf /etc/_dnsmasq.conf.org
	fi
	if [ ! -e /etc/dnsmasq.conf ]; then
		cp $INSTALL_DIR/package/dnsmasq.conf /etc/dnsmasq.conf
		/etc/init.d/dnsmasq restart
	fi
	chmod 666 /etc/dnsmasq.conf
fi
# DNS対応
if [ -e $INSTALL_DIR/package/resolv-head.conf ]; then
	if [ ! -e $INSTALL_DIR/aile/resolv-head.conf.default ]; then
		cp $INSTALL_DIR/package/resolv-head.conf $INSTALL_DIR/aile/resolv-head.conf.default
	fi
	if [ ! -e $INSTALL_DIR/aile/config/resolv-head.conf ]; then
		cp $INSTALL_DIR/package/resolv-head.conf $INSTALL_DIR/aile/config/resolv-head.conf
	fi
	if [ ! -e /etc/resolvconf/resolv.conf.d/head.org ]; then
		mv /etc/resolvconf/resolv.conf.d/head /etc/resolvconf/resolv.conf.d/head.org
	fi
	chmod 666 $INSTALL_DIR/aile/config/resolv-head.conf
	chown aile:aile $INSTALL_DIR/aile/config/resolv-head.conf
	ln -fs $INSTALL_DIR/aile/config/resolv-head.conf /etc/resolvconf/resolv.conf.d/head
fi

if [ -e $INSTALL_DIR/package/resolv-tail.conf ]; then
	if [ ! -e $INSTALL_DIR/aile/config/resolv-tail.conf ]; then
		cp $INSTALL_DIR/package/resolv-tail.conf $INSTALL_DIR/aile/config/resolv-tail.conf
	fi
	if [ -e $INSTALL_DIR/aile/add_dns_options.sh ]; then
		bash $INSTALL_DIR/aile/add_dns_options.sh $INSTALL_DIR/aile/config/resolv-tail.conf
	fi
	chmod 666 $INSTALL_DIR/aile/config/resolv-tail.conf
	chown aile:aile $INSTALL_DIR/aile/config/resolv-tail.conf
	ln -fs $INSTALL_DIR/aile/config/resolv-tail.conf /etc/resolvconf/resolv.conf.d/tail
fi
resolvconf -u

if [ -e $INSTALL_DIR/package/ntp.conf ]; then
	if [ ! -e /etc/ntp.conf.org ]; then
		cp /etc/ntp.conf /etc/ntp.conf.org
		cp $INSTALL_DIR/package/ntp.conf /etc/ntp.conf
	fi
fi

# 20-intel.confの配置
if [ -e $INSTALL_DIR/package/20-intel.conf.normal ]; then
	cp $INSTALL_DIR/package/20-intel.conf.normal $INSTALL_DIR/aile/20-intel.conf.normal
	chown aile:aile $INSTALL_DIR/aile/20-intel.conf.normal
	chmod 666 $INSTALL_DIR/aile/20-intel.conf.normal
fi
if [ -e $INSTALL_DIR/package/20-intel.conf.left ]; then
	cp $INSTALL_DIR/package/20-intel.conf.left $INSTALL_DIR/aile/20-intel.conf.left
	chown aile:aile $INSTALL_DIR/aile/20-intel.conf.left
	chmod 666 $INSTALL_DIR/aile/20-intel.conf.left
fi

if [ ! -e /usr/share/X11/xorg.conf.d/20-intel.conf ]; then
	ln -fs $INSTALL_DIR/aile/20-intel.conf.normal /usr/share/X11/xorg.conf.d/20-intel.conf
fi

# Zabbixの設定ファイルをconfigの下に移動
if [ -e $INSTALL_DIR/package/zabbix/zabbix_agentd-temp.conf ]; then
	if [ ! -e $INSTALL_DIR/aile/zabbix ]; then
		mkdir -p $INSTALL_DIR/aile/zabbix
	fi
	cp $INSTALL_DIR/package/zabbix/zabbix_agentd-temp.conf $INSTALL_DIR/aile/zabbix/zabbix_agentd-temp.conf
fi
if [ -e /etc/zabbix/zabbix_agentd.conf ]; then
	if [ ! -L /etc/zabbix/zabbix_agentd.conf ]; then
		mv /etc/zabbix/zabbix_agentd.conf $INSTALL_DIR/aile/config/zabbix_agentd.conf
		cp $INSTALL_DIR/aile/config/zabbix_agentd.conf $INSTALL_DIR/aile/zabbix/zabbix_agentd.conf.org
		ln -fs $INSTALL_DIR/aile/config/zabbix_agentd.conf /etc/zabbix/zabbix_agentd.conf
		chown aile:aile $INSTALL_DIR/aile/config/zabbix_agentd.conf
	fi
fi

# sudoersの更新
if [ -e $INSTALL_DIR/package/aile-sudoers ]; then
	chmod 664 /etc/sudoers.d/aile-sudoers
	cp $INSTALL_DIR/package/aile-sudoers /etc/sudoers.d/aile-sudoers
	chmod 440 /etc/sudoers.d/aile-sudoers
fi

# 20auto-upgradesの差し替え(自動アップデート無効)
if [ -e $INSTALL_DIR/package/20auto-upgrades ]; then
	mv $INSTALL_DIR/package/20auto-upgrades /etc/apt/apt.conf.d/20auto-upgrades
fi

if [ ! -e /etc/modules.org ]; then
	cp /etc/modules /etc/modules.org
fi
if [ -e $INSTALL_DIR/package/modules.conf ]; then
	if [ -e /etc/modules.org ]; then
		cp -f /etc/modules.org /etc/modules
	fi
	cat $INSTALL_DIR/package/modules.conf >> /etc/modules
fi
rm -rf $INSTALL_DIR/package

setcap cap_net_raw=ep $INSTALL_DIR/aile/IpChecker
setcap cap_net_admin=ep $INSTALL_DIR/aile/MyNetworkSetting
setcap cap_sys_time,cap_dac_override=ep $INSTALL_DIR/aile/MyClockSetting
setcap cap_setuid,cap_setgid,cap_sys_admin,CAP_FOWNER=ep $INSTALL_DIR/aile/automount
setcap cap_sys_rawio,cap_dac_read_search=ep $INSTALL_DIR/aile/hwcheck
setcap cap_setuid,cap_setgid,cap_sys_admin,cap_net_admin,CAP_FOWNER,cap_kill=ep $INSTALL_DIR/systemd/aile/bin/checkprocess
setcap cap_setuid,cap_setgid=ep $INSTALL_DIR/aile/OutputLog
setcap cap_setuid,cap_setgid=ep $INSTALL_DIR/systemd/aile/bin/OutputSensorInfo
setcap cap_net_admin=ep $INSTALL_DIR/aile/arpdel
setcap cap_sys_rawio,cap_dac_read_search,cap_dac_override=ep $INSTALL_DIR/aile/remocon
setcap cap_sys_time,cap_dac_override=ep $INSTALL_DIR/aile/syncClock
rm -f /etc/cron.hourly/syncClock
mv $INSTALL_DIR/aile/ntpdate /etc/network/if-up.d/ntpdate
ln -fs /etc/network/if-up.d/ntpdate /etc/cron.hourly/ntpdate

CRONTAB_FILE=/etc/crontab
CRONTAB_ORIGINAL_FILE=/etc/crontab.org

if [ ! -e $CRONTAB_ORIGINAL_FILE ]; then
	cp $CRONTAB_FILE $CRONTAB_ORIGINAL_FILE
fi

if [ -e $CRONTAB_ORIGINAL_FILE ]; then
	ALREADYCONF=`cat $CRONTAB_ORIGINAL_FILE | grep "@reboot root /etc/cron.hourly/ntpdate FORCE"`
	if [ -z $ALREADYCONF ]; then
		cp $CRONTAB_ORIGINAL_FILE $CRONTAB_FILE
		echo "@reboot root /etc/cron.hourly/ntpdate FORCE" >> $CRONTAB_FILE
	fi
fi


echo "export GTK2_RC_FILES=$INSTALL_DIR/aile/ui/gtkrc" >> $INSTALL_DIR/aile/startup.sh
echo "sleep 5" >> $INSTALL_DIR/aile/startup.sh
echo "cd $INSTALL_DIR/aile ; ./aile &" >> $INSTALL_DIR/aile/startup.sh
echo "$INSTALL_DIR/aile/packcore.sh &" >> $INSTALL_DIR/aile/startup.sh
echo "sleep 30" >> $INSTALL_DIR/aile/startup.sh
echo "killall xeyes &" >> $INSTALL_DIR/aile/startup.sh

AILE_LOCALE=$INSTALL_DIR/locale

if [ -d $AILE_LOCALE ] ; then
	cp -rfv $AILE_LOCALE /usr/local/share/
	rm -rf $AILE_LOCALE
fi

H264_PKG=$INSTALL_DIR/h264
MJPG_PKG=$INSTALL_DIR/mjpg
H264_EXTRA_PKG=$INSTALL_DIR/h264_extra
AILE_EXCTRL_PKG=$INSTALL_DIR/aile_exctrl
ACLIB_PKG=$INSTALL_DIR/aile_common_lib

if [ -d $ACLIB_PKG ] ; then
	cd $ACLIB_PKG
	sh install.sh
	cd ..
	rm -rf $ACLIB_PKG
fi

if [ -d $H264_PKG ] ; then
	cd $H264_PKG
	sh install.sh
	cd ..
	rm -rf $H264_PKG
fi

if [ -d $MJPG_PKG ] ; then
	cd $MJPG_PKG
	sh install.sh
	cd ..
	rm -rf $MJPG_PKG
fi

if [ -d $H264_EXTRA_PKG ] ; then
	cd $H264_EXTRA_PKG
	make install_lib
	cd ..
	rm -rf $H264_EXTRA_PKG
fi

if [ -d $AILE_EXCTRL_PKG ] ; then
	cd $AILE_EXCTRL_PKG
	sh install.sh
	cd ..
	rm -rf $AILE_EXCTRL_PKG
fi

# configのgtkrcをコピー
if [ -e $INSTALL_DIR/aile/config/gtkrc.conf ]; then
	cp -f $INSTALL_DIR/aile/config/gtkrc.conf $INSTALL_DIR/aile/ui/gtkrc
fi

### EOF ###