#!/bin/sh

# Watchdog Timer install
if [ -e watchdog-timer ]; then
	WDT_VERSION_TXT="version.txt"
	WDT_MODULE_INSTALL_DIR=/opt/aile/WDT
	cd watchdog-timer
	logger "Watchdog Timer Install/Update Start"
	if [ -e $WDT_MODULE_INSTALL_DIR ]; then
		WDT_MODULE_VERSION=`cat $WDT_MODULE_INSTALL_DIR/$WDT_VERSION_TXT | grep "WDT_MODULE" | cut -d":" -f2 | tr -d '\n\r'`
	else
		WDT_MODULE_VERSION=""
	fi
	WDT_MODULE_UV_VERSION=`cat $WDT_VERSION_TXT | grep "WDT_MODULE" | cut -d":" -f2 | tr -d '\n\r'`
	# WDTモジュールの更新
	logger "MODULE OLD:[$WDT_MODULE_VERSION] NEW:[$WDT_MODULE_UV_VERSION]"
	if [ "$WDT_MODULE_VERSION" != "$WDT_MODULE_UV_VERSION" ] ; then
		unzip -o WDT_Linux.zip -d $WDT_MODULE_INSTALL_DIR
		cp $WDT_VERSION_TXT $WDT_MODULE_INSTALL_DIR/$WDT_VERSION_TXT
		chmod 755 $WDT_MODULE_INSTALL_DIR/ECWDT1.10.exe
		chown -R aile:aile $WDT_MODULE_INSTALL_DIR
	fi
	if [ -e $WDT_MODULE_INSTALL_DIR/WDT.txt ]; then
		mv $WDT_MODULE_INSTALL_DIR/WDT.txt /opt/aile/WDT.txt
	fi
	if [ -e aile-sudoers ]; then
		logger "aile-sudoers update"
		cp aile-sudoers /etc/sudoers.d/aile-sudoers
	fi
	logger "Watchdog Timer Install/Update End"
fi
