#! /bin/sh
logger -t webapp "cmpressConfigFiles.sh"


AS_CC100_CONFIG_DIR=/opt/piLab/config
ZIP_CONFIG_DIR=ascc100_1
BASE_PATH=`pwd`
DATA_DIR=$BASE_PATH/$1
WORK_DIR=/tmp/$ZIP_CONFIG_DIR/config
COMPRESS_FILE=/tmp/as-cc100.zip

rm -f $DATA_DIR/as-cc100*

# create working directory
mkdir -p $WORK_DIR

cp $AS_CC100_CONFIG_DIR/* $WORK_DIR/
rm $WORK_DIR/Config.xml
rm $WORK_DIR/DeviceLog.xml
rm $WORK_DIR/SensorsLog.xml
rm $WORK_DIR/ntpStatus.txt
rm $WORK_DIR/ports.conf
rm $WORK_DIR/ascc100-sites

if [ $2 = "remove_tmp_cmd" ]; then
    rm $WORK_DIR/CommandTemplate.xml
fi

cd /tmp
zip -A -r $COMPRESS_FILE $ZIP_CONFIG_DIR/*
rm -fr $WORK_DIR
mv $COMPRESS_FILE $DATA_DIR
