#!/bin/bash

# 0は無効 1オリジンで使用する
outports=( 0 11 5 6 13 )

for outport in ${!outports[@]}; do
  if [ $1 = $outport ]; then
    selport=${outports[$outport]}
  fi
done

#現在の状態を取得
curState=$(/bin/sudo /bin/cat "/sys/class/gpio/gpio$selport/value")
#デフォルトは、Openとする
# out_port: value=0 -> 端子Hi(off) 
# out_port: value=1 -> 端子Lo(on) 
value=0
if [ $2 = "on" ]; then
  value=1
elif [ $2 = "toggle" ]; then
  if [ $curState = "1" ]; then
    value=0
  else
    value=1
  fi
fi

/bin/echo "$value" | /bin/sudo /bin/tee /sys/class/gpio/gpio$selport/value

if [ $value != $curState ]; then
  if [ $value = "1" ]; then
    /bin/echo "command=output&port=$1&state=on" | /bin/nc 127.0.0.1 24692
  else
    /bin/echo "command=output&port=$1&state=off" | /bin/nc 127.0.0.1 24692
  fi
fi